@extends('frontend.user.layouts.app')

@section('content')
    @php
        $count = translate('Domains', 'general');
        $get_domain_feature == 'true' || $get_domain_feature == '-1'
            ? ''
            : ($count .= ' (' . $count_domains . '/' . $get_domain_feature . ')');
    @endphp

    <x-breadcrumb :title='$count' :nav="false">
        <div class="col-auto">
            @if ($get_domain_feature == 'true' || $get_domain_feature == '-1' || $get_domain_feature > $count_domains)
                <a href="{{ route('domains.create') }}" class="btn btn-primary h-100">
                    <i class="fa-solid fa-plus mx-1"></i>
                    {{ translate('Add New Domain', 'general') }}
                </a>
            @endif
        </div>
    </x-breadcrumb>

    <div class="box p-3">
        <div class="table-inner">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th class="text-center">{{ translate('Domain Name', 'general') }}</th>
                            <th class="text-center">{{ translate('Status', 'general') }}</th>
                            <th class="text-center">{{ translate('Created At', 'general') }}</th>
                            <th class="text-center">{{ translate('Actions', 'general') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($domains as $domain)
                            <tr>
                                <td class="text-center">
                                    {{ $domain->domain }}
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-{{ $domain->getStatusColor() }}-lt">
                                        {{ $domain->getStatusLabel() }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    {{ toDate($domain->created_at) }}
                                </td>
                                <td class="d-flex justify-content-center">
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-danger cp-x-2" data-bs-toggle="modal"
                                            data-bs-target="#deleteModal" data-id="{{ $domain->id }}"
                                            data-action="{{ route('domains.destroy', $domain->id) }}">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center empty-svg">
                                    <svg id="svg-color" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 500">
                                        <g id="freepik--background-complete--inject-66">
                                            <path
                                                d="M452.43,345.3l-41.07-15.64a5.51,5.51,0,0,1-3.19-7.1l21.65-56.84a5.51,5.51,0,0,1,7.1-3.19L463,272.45l12.25,28.46-15.7,41.21A5.49,5.49,0,0,1,452.43,345.3Z"
                                                style="fill:#ebebeb"></path>
                                            <path d="M463,272.45l-6.1,16a5.12,5.12,0,0,0,3,6.6l15.39,5.86Z"
                                                style="fill:#e0e0e0"></path>
                                            <path
                                                d="M453.68,286.49c-.08.2-4.4-1.25-9.64-3.25s-9.44-3.78-9.36-4,4.39,1.25,9.64,3.25S453.76,286.28,453.68,286.49Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M462.51,300.21c-.08.2-7.15-2.3-15.78-5.59s-15.58-6.12-15.5-6.32,7.14,2.29,15.78,5.58S462.58,300,462.51,300.21Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M462.44,308.83c-.07.21-7.77-2.53-17.18-6.12s-17-6.65-16.9-6.86,7.77,2.53,17.18,6.12S462.52,308.63,462.44,308.83Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M459.73,316c-.08.21-7.77-2.53-17.18-6.12s-17-6.66-16.91-6.86,7.77,2.53,17.19,6.12S459.81,315.75,459.73,316Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M457,323.09c-.08.2-7.78-2.54-17.19-6.12s-17-6.66-16.9-6.87,7.77,2.54,17.18,6.12S457.09,322.88,457,323.09Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M454.3,330.21c-.08.21-7.77-2.53-17.18-6.11s-17-6.66-16.91-6.87,7.77,2.53,17.19,6.12S454.38,330,454.3,330.21Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M258,162.9c-.12-1.26-.26-2.5-.43-3.73s-.37-2.61-.59-3.91c.22,1.3.42,2.6.59,3.91S257.83,161.64,258,162.9Z"
                                                style="fill:#f5f5f5"></path>
                                            <path
                                                d="M247.94,178.36c-1.08-2.44-1.32-5.14-2-7.71a5.09,5.09,0,0,0-2.31-3.45,21.17,21.17,0,0,0-2.78-.63c-3.26-1-4.14-5.52-7.23-6.93a10.33,10.33,0,0,0-3.1-.65c-4.13-.49-8.41-1.92-11-5.16a20.46,20.46,0,0,0-2.55-3.14c-1.06-.85-2.7-1.22-3.73-.35q1.31,2.63,2.58,5.22a13.77,13.77,0,0,0,2.9,4.34,4.64,4.64,0,0,0,4.86,1,3.24,3.24,0,0,1,1.64-.57,1.76,1.76,0,0,1,1.06.68c2.25,2.49,1.52,6.62-.68,9.17s-5.42,3.85-8.54,5.09a6.69,6.69,0,0,1-3.49.68c-2.16-.4-3.31-2.76-3.94-4.87-1.41-4.67-2.09-9.74-5-13.68a16.67,16.67,0,0,1-2.63-3.82c-.6-1.57-.46-3.4-1.4-4.77s-3.05-2.29-3.19-4a3.19,3.19,0,0,1,2-2.83c1.12-.54,2.37-.69,3.52-1.16.45-.2,1-.53,1-1,0-.74-1-1-1.28-1.71s.51-1.49.84-2.23c.72-1.71-1.06-3.44-2.79-4.14s-3.78-1.2-4.58-2.87a10,10,0,0,1-.56-2.5,5.45,5.45,0,0,0-4.08-4.49c-2.14-.35-4.51,1.55-4.17,3.68.21,1.16,1.09,2.07,1.56,3.15s.34,2.69-.77,3c-1.83.56-3.59-2.79-5.13-1.63.63,2.14,1.24,4.28,1.87,6.45-2.41,1.22-5.28-1-6.31-3.51s-1.07-5.35-2.29-7.76-4.51-4.21-6.6-2.51c-.11,3.11,4,4.36,5.8,6.87,1.31,1.82,1.12,4.76-.82,5.91s-5-.85-4.23-3c.26-.73.87-1.34.94-2.13.07-1-.75-1.76-1.5-2.39l-3.5-2.94a7.38,7.38,0,0,0-2.5-1.57c-2.4-.7-4.81,1.25-6.08,3.4s-2,4.69-3.75,6.48c-2.53,2.62-7.32,2.77-9.69,0s-1.17-7.87,2.33-8.86c1.33-.36,3-.33,3.7-1.5,1.22-2.07-2.27-4.72-1.06-6.81.92-1.61,3.36-.88,5.14-1.42s2.75-2.31,3.8-3.85,2.65-3,4.46-2.65a5.58,5.58,0,0,1,.19-3.17,2,2,0,0,1,2.67-1c-.89,1.47.18,3.51,1.73,4.24a9.35,9.35,0,0,0,5.07.36c1.71-.2,3.85-.83,4-2.54,0-.56-.16-1.15,0-1.67.75-2,4.52.76,6-.88.83-.85-.09-2.37-1.26-2.65s-2.35.14-3.54.18-2.63-.58-2.68-1.76,1.25-2,1.39-3.16c.23-2-3.08-2.45-4.25-.87s-.75,3.77-.4,5.7.54,4.22-.89,5.58c-.61.92-2.2.44-2.72-.54a7.92,7.92,0,0,1-.51-3.26c-.08-1.12-.57-2.37-1.65-2.67a6,6,0,0,0-2.32.26c-3,.37-5.14-3.55-4.19-6.45s3.7-4.77,6.37-6.25c2-1.08,4.37-2.1,6.31-1,.9.51,1.53,1.38,2.42,1.9,1.54.91,3.44.58,5.2.61a12.13,12.13,0,0,1,7.58,3c.78.71,1.52,1.9.91,2.75s-2.57,1.1-2.24,2.16a3.78,3.78,0,0,0,4.75-3,3.2,3.2,0,0,1,1.83,2.58,5.66,5.66,0,0,1,8.28.68,7.09,7.09,0,0,0,1.53,2c.7.46,1.92.23,2-.59a1.88,1.88,0,0,0-.14-.77c-.42-1.18-.86-2.35-1.28-3.52,1.63-.87,3.54.49,4.64,2,4.08,5.45,7,2.17,12.74,3.06,3.89.6,5.6,3.09,7.8,6.1,6.73,9.28,15.62,16.88,21.74,26.57.64,1,1.23,2,1.79,3.09-.1-.26-.19-.53-.3-.79a106.71,106.71,0,0,0-8.89-18.07c-.75-1.22-1.51-2.43-2.3-3.61-.49-.74-1-1.48-1.5-2.2-.64-.94-1.32-1.85-2-2.75-.54-.74-1.08-1.45-1.64-2.15-.38-.49-.78-1-1.19-1.46a20.36,20.36,0,0,0-1.36-1.64L230.93,101c-.14-.18-.3-.35-.47-.53-.51-.59-1.05-1.16-1.59-1.74a.4.4,0,0,0-.15-.17c-.14-.16-.3-.32-.46-.47-.43-.49-.9-1-1.36-1.43-.75-.77-1.51-1.54-2.3-2.27-.64-.64-1.3-1.25-2-1.86s-1.19-1.09-1.8-1.61-1.19-1-1.8-1.53-1.48-1.24-2.25-1.85h0c-2.11-1.69-4.29-3.29-6.52-4.79-.56-.39-1.1-.75-1.66-1.12s-1.13-.73-1.69-1.08-1.13-.72-1.71-1.05-1.15-.69-1.72-1-.93-.54-1.4-.78a6.36,6.36,0,0,0-.71-.4c-1-.56-2-1.1-3-1.6-.5-.27-1-.53-1.53-.77s-1.31-.65-2-.94a1.38,1.38,0,0,0-.3-.14c-.59-.28-1.18-.56-1.79-.82-.86-.37-1.71-.73-2.57-1.08s-1.95-.8-2.94-1.17-2.2-.82-3.32-1.19-2.24-.75-3.38-1.09-2.26-.67-3.41-1q-3.41-.91-6.89-1.62s-.09,0-.12,0c-.89-.17-1.78-.34-2.67-.48a.68.68,0,0,0-.17,0c-.39-.07-.79-.14-1.19-.19-1.65-.28-3.33-.51-5-.7l-.61-.07c-.49-.07-1-.1-1.48-.15-1.12-.11-2.23-.2-3.37-.27s-2.35-.14-3.53-.17-2.48-.07-3.72-.07c-3.27,0-6.52.14-9.73.44-.76,0-1.51.12-2.26.2l-2.35.28c-.79.11-1.57.21-2.34.33l-2.34.39c-.66.1-1.34.22-2,.36q-2.46.48-4.86,1c-.75.17-1.5.37-2.25.58s-1.5.4-2.24.61c-1.23.34-2.44.73-3.64,1.11h0c-1,.33-2,.66-2.92,1,0,0-.06,0-.07,0-1,.35-2,.71-2.93,1.1l-.16,0c-.89.35-1.78.72-2.65,1.08-1.1.45-2.18.94-3.24,1.43-.91.42-1.8.84-2.67,1.27s-1.88.94-2.81,1.43l-.1.06c-.89.47-1.78,1-2.65,1.46s-1.8,1-2.69,1.59h0c-.84.5-1.66,1-2.48,1.53-.31.19-.61.4-.92.61-.87.56-1.71,1.13-2.56,1.73-1,.71-2.06,1.46-3.07,2.21s-1.76,1.34-2.62,2a110,110,0,0,0-13.7,13c-1.48,1.64-2.88,3.31-4.24,5q-1.72,2.19-3.33,4.48c-1,1.33-1.88,2.69-2.77,4.07.89-1.38,1.82-2.74,2.77-4.07l.84-.09a12.84,12.84,0,0,0,4.64-.75c1.31-.64,2.23-1.81,3.42-2.65,3-2.16,8-2.56,8.82-6.19.28-1.22-.06-2.54.4-3.71.85-2.18,3.76-2.49,6.1-2.46,1,0,2.16.14,2.61,1a2.53,2.53,0,0,1-.1,2,18.93,18.93,0,0,1-8,9.83c-3,1.85-7,3.28-7.83,6.73.42,1.17,2.55,1.08,2.72,2.3.12,1-1.13,1.48-1.59,2.35-.66,1.28.86,2.83,2.3,2.76s2.65-1.12,3.72-2.09c3.17-3,6.5-6.12,7.65-10.31.49-1.72.66-3.75,2.06-4.9a3.4,3.4,0,0,1,5.17,1.66c1.38-.77,3.53-1.34,4.24.09a7.42,7.42,0,0,1,.3,1.64c.45,2.23,3.5,3.24,3.82,5.49.36,2.59-3,3.94-5.57,4.34l-7.06,1.11a6.54,6.54,0,0,0-2.92.94,2.3,2.3,0,0,0-.88,2.74,6.92,6.92,0,0,0,1.22,1.26c2,2,.35,6-2.4,6.06-.94,0-1.87-.31-2.81-.35-2.79-.12-5,2.34-6.33,4.8s-2.31,5.26-4.55,6.94c-3.59,2.7-9.78,2.07-11.52,6.22-.7,1.67-.33,3.56,0,5.35s.4,3.77-.65,5.25-3.71,1.78-4.48.14a4.06,4.06,0,0,1-.1-2.32c.42-2.58.82-5.16,1.22-7.74.3-1.92.56-4.06-.58-5.63-1.58-2.2-5.14-2-7.2-.23s-2.89,4.52-3.46,7.15a31.22,31.22,0,0,1-2,6.94h0c-.37,2.16-.67,4.36-.89,6.57s-.39,4.52-.47,6.82a11,11,0,0,0,.89-.84c1.1-1.13,3.31-5.93,5.3-3.57a1.79,1.79,0,0,1,0,2.18c-.61.78-1.83,1-2.3,1.81-.57,1,.23,2.26,1.17,2.93s2.09,1.09,2.75,2.05c1.28,1.83.06,4.61,1.29,6.47,1.07,1.61,3.33,1.71,5.27,1.92l.66.1c.54-3.83,2.34-6.95,7.57-8.14,7.21-1.64,16.7,4.34,20.76,9.78,4.53,6.09,6.67,14.7,13.61,17.75,5,2.18,12,1.39,14.45,6.26,2.17,4.36-1.6,9.25-2.18,14.08-.36,3.19.68,6.37.93,9.56s-.72,6.93-3.63,8.28c-1.62.73-3.66.64-5,1.86-2.31,2.2-.41,6.73-2.73,8.93a12.19,12.19,0,0,1-3,1.55c-5.21,2.63-5.07,10.3-2.65,15.62.09.19.18.36.26.56A110.17,110.17,0,0,0,200,271.08h0a111.79,111.79,0,0,0,9.74-5.87,109.15,109.15,0,0,0,13.69-10.88,107.65,107.65,0,0,0,8.36-8.73c1.85-2.13,3.6-4.34,5.27-6.61.85-1.17,1.69-2.34,2.47-3.54a105.15,105.15,0,0,0,6.58-11,106.73,106.73,0,0,0,7.13-17.19,107.86,107.86,0,0,0,4.2-18.67c.33-2.47.59-5,.76-7.51a6.34,6.34,0,0,1-4.42,2C251.19,183,249,180.8,247.94,178.36Z"
                                                style="fill:#f5f5f5"></path>
                                            <path
                                                d="M52.59,202.76c-.34-3.15.7-6.31.75-9.5,0-2.19-.12-4.51-.15-6.73a29.39,29.39,0,0,1-5.6-.78,1.73,1.73,0,0,1-1-.52,2,2,0,0,1-.22-1.17c-.14-2.48-2.53-4.11-4.67-5.35a18.52,18.52,0,0,0-3.4-1.68c0,.27,0,.51,0,.77a109.89,109.89,0,0,0,7,34.95A104.74,104.74,0,0,0,52,227.19c1.08,2,2.27,4,3.5,5.91,1.54,2.39,3.14,4.72,4.87,7s3.31,4.27,5.11,6.29a105.26,105.26,0,0,0,7.79,8c2.42,2.27,4.95,4.41,7.58,6.45-6-16.14-11.68-32.61-22-46.35C56.2,210.89,53.1,207.23,52.59,202.76Z"
                                                style="fill:#f5f5f5"></path>
                                            <path
                                                d="M38.25,171.82c0,.67,0,1.33,0,2s0,1.07,0,1.61c0-.54,0-1.07,0-1.61S38.24,172.49,38.25,171.82Z"
                                                style="fill:#f5f5f5"></path>
                                            <g style="opacity:0.6000000000000001">
                                                <path
                                                    d="M87,265.3c.92.62,1.86,1.23,2.81,1.83l2,1.22-2-1.22C88.9,266.53,88,265.92,87,265.3Z"
                                                    style="fill:#f5f5f5"></path>
                                            </g>
                                            <path
                                                d="M180.33,258.39a9.4,9.4,0,0,1-2.05-.22,6.73,6.73,0,0,1-4.86-3.68,12.51,12.51,0,0,1-.85-4.8,18,18,0,0,0-.35-3.28,17.26,17.26,0,0,0-2.58-5.26,18.33,18.33,0,0,1-3.45-12.42l0-.68c-.58-19.37-6-35.1-15.62-45.48a10.6,10.6,0,0,0-4.73-3.35,5.9,5.9,0,0,0-6.07,2.1,12.33,12.33,0,0,0-.91,1.49,8.46,8.46,0,0,1-1.59,2.27,4.55,4.55,0,0,1-3.88,1,7,7,0,0,1-4.84-3.34c-1.71-3-1.4-6.72-1.15-9.71l1-12c.16-1.86.37-4.4,1.87-6.14a10.26,10.26,0,0,1,4.47-2.56,13.32,13.32,0,0,0,3.44-1.65c1.93-1.45,2.79-3.73,3.7-6.14a24.77,24.77,0,0,1,1.75-4,7.41,7.41,0,0,1,6.9-3.39,3.19,3.19,0,0,1,2.53,1.69,7.59,7.59,0,0,1,4.49-4.11c4-1.15,8.84,2,13.53,5.05,4.29,2.79,8.33,5.41,11.51,4.83a24.71,24.71,0,0,0,2.4-.59,12.67,12.67,0,0,1,5.17-.71c4.63.65,7,5.67,8.53,10l7.53,21c.94,2.62,2.15,5.49,4.64,6.46a9.47,9.47,0,0,0,3.14.46,10.5,10.5,0,0,1,3.28.47,5.26,5.26,0,0,1,3.46,4.24c.64,3.48-1.1,8-4.05,10.58h0a48.76,48.76,0,0,1-4.42,3.25c-3.4,2.32-6.62,4.51-8,8.11a19.47,19.47,0,0,0-.93,6.15,18.93,18.93,0,0,1-1.07,6.63,19.15,19.15,0,0,1-3.27,4.77,29.54,29.54,0,0,0-2.19,2.79c-2.41,3.63-3.08,8.14-3.73,12.49-.08.56-.16,1.12-.25,1.67-.75,4.86-2.05,10.27-6,13.65A10.17,10.17,0,0,1,180.33,258.39Z"
                                                style="fill:#ebebeb"></path>
                                            <g style="opacity:0.6000000000000001">
                                                <path
                                                    d="M38.32,169.22h0c0,.21,0,.4,0,.61,0,.66,0,1.33,0,2,0-.66,0-1.33,0-2C38.28,169.62,38.3,169.43,38.32,169.22Z"
                                                    style="fill:#f5f5f5"></path>
                                            </g>
                                            <g style="opacity:0.6000000000000001">
                                                <path
                                                    d="M38.24,175.42c0,.54,0,1.08,0,1.61h0C38.25,176.5,38.25,176,38.24,175.42Z"
                                                    style="fill:#f5f5f5"></path>
                                            </g>
                                            <path
                                                d="M53.38,182.26l-.66-.1c-1.94-.21-4.2-.31-5.27-1.92-1.23-1.86,0-4.64-1.29-6.47-.66-1-1.81-1.37-2.75-2.05s-1.75-1.92-1.17-2.93c.47-.86,1.69-1,2.3-1.81a1.79,1.79,0,0,0,0-2.18c-2-2.36-4.2,2.44-5.3,3.57a11,11,0,0,1-.89.84h0c0,.21,0,.4,0,.61,0,.66,0,1.33,0,2s0,1.33,0,2,0,1.07,0,1.61,0,1.08,0,1.61a18.13,18.13,0,0,1,3.39,1.68c2.15,1.23,4.54,2.87,4.68,5.35a2,2,0,0,0,.22,1.17,1.73,1.73,0,0,0,1,.52,29.39,29.39,0,0,0,5.6.78"
                                                style="fill:#ebebeb"></path>
                                            <path
                                                d="M53.19,186.53c0,2.22.19,4.54.15,6.73-.05,3.19-1.09,6.35-.74,9.5.5,4.47,3.6,8.13,6.31,11.72,10.28,13.74,16,30.21,22,46.35h0c1.11.89,2.25,1.73,3.4,2.55.9.65,1.82,1.29,2.75,1.92s1.86,1.23,2.81,1.83l2,1.22c-.08-.2-.17-.37-.26-.56-2.42-5.32-2.56-13,2.65-15.62a12.19,12.19,0,0,0,3-1.55c2.32-2.2.42-6.73,2.73-8.93,1.31-1.22,3.35-1.13,5-1.86,2.91-1.35,3.86-5.08,3.63-8.28s-1.29-6.37-.93-9.56c.58-4.83,4.35-9.72,2.18-14.08-2.42-4.87-9.48-4.08-14.45-6.26C88.38,198.6,86.24,190,81.71,183.9c-4.06-5.44-13.55-11.42-20.76-9.78-5.23,1.19-7,4.31-7.57,8.14"
                                                style="fill:#ebebeb"></path>
                                            <path
                                                d="M45.13,141.73c2.06-1.76,5.62-2,7.2.23,1.14,1.57.88,3.71.58,5.63-.4,2.58-.8,5.16-1.22,7.74a4.06,4.06,0,0,0,.1,2.32c.77,1.64,3.45,1.32,4.48-.14s.93-3.47.65-5.25-.65-3.68,0-5.35c1.74-4.15,7.93-3.52,11.52-6.22,2.24-1.68,3.23-4.48,4.55-6.94s3.54-4.92,6.33-4.8c.94,0,1.87.39,2.81.35,2.75-.08,4.36-4.11,2.4-6.06A6.92,6.92,0,0,1,83.36,122a2.3,2.3,0,0,1,.88-2.74,6.54,6.54,0,0,1,2.92-.94l7.06-1.11c2.6-.4,5.93-1.75,5.57-4.34-.32-2.25-3.37-3.26-3.82-5.49a7.42,7.42,0,0,0-.3-1.64c-.71-1.43-2.86-.86-4.24-.09A3.4,3.4,0,0,0,86.26,104c-1.4,1.15-1.57,3.18-2.06,4.9-1.15,4.19-4.48,7.36-7.65,10.31-1.07,1-2.27,2-3.72,2.09s-3-1.48-2.3-2.76c.46-.87,1.71-1.37,1.59-2.35-.17-1.22-2.3-1.13-2.72-2.3.84-3.45,4.79-4.88,7.83-6.73a18.93,18.93,0,0,0,8-9.83,2.53,2.53,0,0,0,.1-2c-.45-.87-1.62-1-2.61-1-2.34,0-5.25.28-6.1,2.46-.46,1.17-.12,2.49-.4,3.71-.82,3.63-5.79,4-8.82,6.19-1.19.84-2.11,2-3.42,2.65a12.84,12.84,0,0,1-4.64.75l-.84.09c-1,1.33-1.88,2.69-2.77,4.07S54,117,53.15,118.39a109.49,109.49,0,0,0-9.55,21.3c-.85,2.61-1.61,5.26-2.26,7.95s-1.21,5.42-1.66,8.18a31.22,31.22,0,0,0,2-6.94C42.24,146.25,43.09,143.49,45.13,141.73Z"
                                                style="fill:#ebebeb"></path>
                                            <path
                                                d="M137.54,90.64c1-1.37.73-3.33,1.41-4.91,1.12-2.62,4.61-3.56,5.82-6.15.46-1,.58-2.21,1.39-2.94s1.68-.75,2.4-1.3c1.63-1.25.95-4.08-.77-5.18-4.32-2.76-12.27.43-16,3.14-4.8,3.47-9.49,7.65-15.88,7.24-1.76-.11-3.59-.59-5.24,0s-2.67,3.1-1.25,4.14c.79.59,1.91.42,2.81.84,1.64.76,1.81,3.14,1,4.77S111,93.16,110,94.71a8.26,8.26,0,0,0-1.18,5,4.58,4.58,0,0,0,1.49,3.25c2,1.58,5,.22,6.69-1.68s2.85-4.37,5-5.68a12.36,12.36,0,0,1,3.58-1.24l8.33-2A6.1,6.1,0,0,0,137.54,90.64Z"
                                                style="fill:#ebebeb"></path>
                                            <g style="opacity:0.6000000000000001">
                                                <path
                                                    d="M258.46,172.29c0-1.58-.06-3.16-.15-4.72.09,1.56.14,3.14.15,4.72,0,.51,0,1,0,1.52,0,2.44-.09,4.84-.23,7.25.14-2.41.23-4.81.23-7.25C258.49,173.3,258.49,172.8,258.46,172.29Z"
                                                    style="fill:#f5f5f5"></path>
                                            </g>
                                            <g style="opacity:0.6000000000000001">
                                                <path
                                                    d="M251.57,135.34c.52,1.39,1,2.79,1.48,4.21-.46-1.42-1-2.82-1.48-4.21,0,0,0,0,0,0h0Z"
                                                    style="fill:#f5f5f5"></path>
                                            </g>
                                            <path
                                                d="M258.46,172.29c0-1.58-.06-3.16-.15-4.72s-.2-3.12-.36-4.67c-.12-1.26-.26-2.5-.43-3.73s-.37-2.61-.59-3.91a106.48,106.48,0,0,0-2.57-11.44c-.41-1.43-.85-2.86-1.31-4.27s-1-2.82-1.48-4.21v0h0c-.56-1-1.15-2.08-1.79-3.09-6.12-9.69-15-17.29-21.74-26.57-2.2-3-3.91-5.5-7.8-6.1-5.75-.89-8.66,2.39-12.74-3.06-1.1-1.47-3-2.83-4.64-2,.42,1.17.86,2.34,1.28,3.52a1.88,1.88,0,0,1,.14.77c-.09.82-1.31,1-2,.59a7.09,7.09,0,0,1-1.53-2,5.66,5.66,0,0,0-8.28-.68,3.2,3.2,0,0,0-1.83-2.58,3.78,3.78,0,0,1-4.75,3c-.33-1.06,1.57-1.25,2.24-2.16s-.13-2-.91-2.75a12.13,12.13,0,0,0-7.58-3c-1.76,0-3.66.3-5.2-.61-.89-.52-1.52-1.39-2.42-1.9-1.94-1.1-4.36-.08-6.31,1-2.67,1.48-5.42,3.34-6.37,6.25s1.16,6.82,4.19,6.45a6,6,0,0,1,2.32-.26c1.08.3,1.57,1.55,1.65,2.67a7.92,7.92,0,0,0,.51,3.26c.52,1,2.11,1.46,2.72.54,1.43-1.36,1.25-3.64.89-5.58s-.75-4.11.4-5.7,4.48-1.08,4.25.87c-.14,1.15-1.44,2-1.39,3.16s1.5,1.81,2.68,1.76,2.39-.47,3.54-.18,2.09,1.8,1.26,2.65c-1.45,1.64-5.22-1.16-6,.88-.21.52,0,1.11,0,1.67-.14,1.71-2.28,2.34-4,2.54a9.35,9.35,0,0,1-5.07-.36c-1.55-.73-2.62-2.77-1.73-4.24a2,2,0,0,0-2.67,1,5.58,5.58,0,0,0-.19,3.17c-1.81-.4-3.43,1.13-4.46,2.65s-2,3.31-3.8,3.85-4.22-.19-5.14,1.42c-1.21,2.09,2.28,4.74,1.06,6.81-.7,1.17-2.37,1.14-3.7,1.5-3.5,1-4.72,6.12-2.33,8.86s7.16,2.58,9.69,0c1.76-1.79,2.48-4.32,3.75-6.48s3.68-4.1,6.08-3.4a7.38,7.38,0,0,1,2.5,1.57l3.5,2.94c.75.63,1.57,1.41,1.5,2.39-.07.79-.68,1.4-.94,2.13-.73,2.11,2.32,4.11,4.23,3s2.13-4.09.82-5.91c-1.81-2.51-5.91-3.76-5.8-6.87,2.09-1.7,5.38.09,6.6,2.51s1.26,5.27,2.29,7.76,3.9,4.73,6.31,3.51c-.63-2.17-1.24-4.31-1.87-6.45,1.54-1.16,3.3,2.19,5.13,1.63,1.11-.34,1.25-2,.77-3s-1.35-2-1.56-3.15c-.34-2.13,2-4,4.17-3.68a5.45,5.45,0,0,1,4.08,4.49,10,10,0,0,0,.56,2.5c.8,1.67,2.87,2.18,4.58,2.87s3.51,2.43,2.79,4.14c-.33.74-1.11,1.46-.84,2.23s1.28,1,1.28,1.71c0,.48-.53.81-1,1-1.15.47-2.4.62-3.52,1.16a3.19,3.19,0,0,0-2,2.83c.14,1.74,2.21,2.58,3.19,4s.8,3.2,1.4,4.77a16.67,16.67,0,0,0,2.63,3.82c2.89,3.94,3.57,9,5,13.68.63,2.11,1.78,4.47,3.94,4.87a6.69,6.69,0,0,0,3.49-.68c3.12-1.24,6.36-2.56,8.54-5.09s2.93-6.68.68-9.17a1.76,1.76,0,0,0-1.06-.68,3.24,3.24,0,0,0-1.64.57,4.64,4.64,0,0,1-4.86-1,13.77,13.77,0,0,1-2.9-4.34q-1.28-2.59-2.58-5.22c1-.87,2.67-.5,3.73.35a20.46,20.46,0,0,1,2.55,3.14c2.59,3.24,6.87,4.67,11,5.16a10.33,10.33,0,0,1,3.1.65c3.09,1.41,4,6,7.23,6.93a21.17,21.17,0,0,1,2.78.63,5.09,5.09,0,0,1,2.31,3.45c.72,2.57,1,5.27,2,7.71s3.25,4.65,5.9,4.69a6.34,6.34,0,0,0,4.42-2v0c.14-2.41.23-4.81.23-7.25C258.49,173.3,258.49,172.8,258.46,172.29Z"
                                                style="fill:#ebebeb"></path>
                                            <path
                                                d="M213.87,218c-1.64.32-2,1.28-2.86,2.5-1.16,1.58-2.82,3.17-3.88,4.73-1.79,2.65-.18,6.77-2.54,9-.48.46-1.1.75-1.53,1.25a2.79,2.79,0,0,0,.57,3.85,3.78,3.78,0,0,0,4.1.08,6.07,6.07,0,0,0,2.52-3.44,5.75,5.75,0,0,1,1.27-2.82c1.35-1.18,3.45-.3,5.22-.55C224.3,231.56,221.05,216.6,213.87,218Z"
                                                style="fill:#ebebeb"></path>
                                            <path
                                                d="M211.68,442.9l-39.34,12.3a5.16,5.16,0,0,1-6.46-3.39l-17-54.45a5.16,5.16,0,0,1,3.39-6.46l24.94-7.8L202.72,397l12.34,39.47A5.16,5.16,0,0,1,211.68,442.9Z"
                                                style="fill:#ebebeb"></path>
                                            <path
                                                d="M163.19,429.07h51.53a0,0,0,0,1,0,0v15a5.46,5.46,0,0,1-5.46,5.46H168.53a5.33,5.33,0,0,1-5.33-5.33V429.07A0,0,0,0,1,163.19,429.07Z"
                                                transform="translate(-122.48 76.4) rotate(-17.36)" style="fill:#e0e0e0">
                                            </path>
                                            <path
                                                d="M182.34,436.74l2.49,7.95-1.77.56-1-3.27-3.46,1.09,1,3.26-1.76.55-2.48-7.95,1.76-.55,1,3.13,3.46-1.08-1-3.14Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M190.2,442.69a2.47,2.47,0,0,1-1.26.82,2.06,2.06,0,0,1-2.87-1.51l-.79-2.51-.9.28-.43-1.36.91-.28-.47-1.49,1.7-.53.46,1.49,1.46-.46.43,1.36L187,439l.78,2.49a.72.72,0,0,0,1,.57,1.06,1.06,0,0,0,.61-.44Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M200.05,436.09l1.09,3.5-1.69.53-1-3.22c-.31-1-.88-1.31-1.56-1.1s-1.14.92-.8,2l1,3.07-1.7.53-1-3.23c-.31-1-.86-1.32-1.56-1.1s-1.13.92-.79,2l1,3.06-1.7.53-1.91-6.11,1.62-.5.22.7a2.46,2.46,0,0,1,1.59-1.37,2.27,2.27,0,0,1,2.24.4,2.72,2.72,0,0,1,1.8-1.66C198.2,433.7,199.47,434.23,200.05,436.09Z"
                                                style="fill:#fff"></path>
                                            <path d="M200,430.69l1.7-.53,2.63,8.42-1.7.53Z" style="fill:#fff"></path>
                                            <path d="M174.41,409.75l-5.67,4.82,7.4.7.88,2.84-10.63-1.19-.92-2.95,8.06-7Z"
                                                style="fill:#fff">
                                            </path>
                                            <path d="M178.82,399.15l2.72-.85.21,23.42-2.73.85Z" style="fill:#fff"></path>
                                            <path d="M194.28,405l.92,3-8.06,7-.89-2.84,5.68-4.79-7.4-.73-.88-2.81Z"
                                                style="fill:#fff"></path>
                                            <g style="opacity:0.30000000000000004">
                                                <path d="M177.18,383.1l4.8,15.33a4.79,4.79,0,0,0,6,3.14l14.74-4.6Z"
                                                    style="fill:#fff"></path>
                                            </g>
                                            <path
                                                d="M182.6,399.71a5.32,5.32,0,0,0,5.58,3.67,4.55,4.55,0,0,0,.52,0c2-.26,15.4-2,15.31-2.25L202.72,397,188,401.58S184.27,402.6,182.6,399.71Z"
                                                style="fill:#e0e0e0"></path>
                                        </g>
                                        <g id="freepik--Floor--inject-66">
                                            <path
                                                d="M455.94,476.93c0,.14-92.21.26-205.93.26s-205.95-.12-205.95-.26,92.19-.26,206-.26S455.94,476.79,455.94,476.93Z"
                                                style="fill:#263238"></path>
                                        </g>
                                        <g id="freepik--Window--inject-66">
                                            <rect x="95.87" y="129.64" width="298.69" height="224.44" style="fill:#fff">
                                            </rect>
                                            <path
                                                d="M394.56,354.08s0-.36,0-1.05,0-1.72,0-3.07c0-2.7,0-6.7-.05-11.93,0-10.44-.06-25.78-.11-45.36-.05-39.1-.13-95.16-.22-163l.43.43-298.66.09h0l.52-.52c0,80.7,0,157.11,0,224.44l-.47-.47,215.58.23,61.23.13,16.25.06,4.19,0,1.07,0h0l-1.05,0-4.13,0-16.16.06-61.12.13-215.89.23H95.4v-.47c0-67.33,0-143.74-.05-224.44v-.52h.55l298.66.1H395v.42c-.09,68-.16,124.14-.22,163.3-.05,19.54-.08,34.84-.11,45.26,0,5.19,0,9.17,0,11.85,0,1.33,0,2.34,0,3S394.56,354.08,394.56,354.08Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M393.06,157.13a6.09,6.09,0,0,1-.75.05l-2.22,0-8.52.09c-7.39.06-18.1.09-31.32.08-26.46,0-63-.19-103.36-.52l-103.36-.83-31.33-.25-8.51-.1-2.22-.06a3.29,3.29,0,0,1-.75,0,3.29,3.29,0,0,1,.75-.05l2.22,0,8.51-.09c7.4-.06,18.1-.09,31.33-.09,26.45,0,63,.2,103.37.53l103.35.83,31.33.24,8.51.11,2.22,0A3.58,3.58,0,0,1,393.06,157.13Z"
                                                style="fill:#263238"></path>
                                            <path d="M115.38,141a3.52,3.52,0,1,1-3.51-3.51A3.52,3.52,0,0,1,115.38,141Z"
                                                style="fill:#263238">
                                            </path>
                                            <path d="M129.45,141a3.52,3.52,0,1,1-3.52-3.51A3.52,3.52,0,0,1,129.45,141Z"
                                                style="fill:#263238">
                                            </path>
                                            <circle cx="140" cy="141.04" r="3.52" style="fill:#263238"></circle>
                                            <rect x="147.93" y="287.41" width="61.38" height="45.95" style="fill:#ebebeb">
                                            </rect>
                                            <rect x="215.34" y="287.41" width="61.38" height="45.95" style="fill:#ebebeb">
                                            </rect>
                                            <rect x="293.9" y="287.41" width="61.38" height="45.95" style="fill:#ebebeb">
                                            </rect>
                                        </g>
                                        <g id="freepik--Rocket--inject-66">
                                            <path
                                                d="M460.81,177.91c-1.87-34.64-38.07-52.07-56.59-54.32L389.4,141c11.93-1.79,41.6,14.77,43.05,26.75s-7.68,27.29-19.7,28.39c-9.44.87-25.18-7.51-31.17-.17-15.14-13.48-41-12.37-54.92,2.36a37.84,37.84,0,0,0-50.36,31.44l55.75,32.36s23.23,20.82,39.07,8c5.41-4.38,7.47-10.67,8-16.74a8.39,8.39,0,0,0,3.16-.2c4-1.08,7-4.68,8.32-8.63.17-.51.3-1,.42-1.55,13.54,3,32-.4,42.89-7.2C449.71,226,461.81,196.54,460.81,177.91Z"
                                                style="fill:#f5f5f5"></path>
                                            <path
                                                d="M385.52,202.71s-.08-.08-.21-.27l-.55-.82c-.24-.37-.54-.82-.93-1.32s-.81-1.11-1.36-1.72a35.9,35.9,0,0,0-10.83-8.72,34.52,34.52,0,0,0-9-3.27,32.53,32.53,0,0,0-11-.5,35.67,35.67,0,0,0-22,11.43c-.83.9-1.56,1.88-2.25,2.78l-.13.18-.19-.1a35.11,35.11,0,0,0-28.6-1,43.5,43.5,0,0,0-4.53,2.27,36.83,36.83,0,0,0-7.29,5.41,29.46,29.46,0,0,0-7.28,10.79c-.3.72-.5,1.37-.68,1.94a15,15,0,0,0-.41,1.45l-.24.9a1,1,0,0,1-.1.3s0-.11.05-.31l.19-.91a11.66,11.66,0,0,1,.37-1.47c.16-.58.35-1.24.63-2a29.28,29.28,0,0,1,7.22-11,36.46,36.46,0,0,1,7.33-5.51,41.53,41.53,0,0,1,4.57-2.32,34.64,34.64,0,0,1,5.19-1.69,35.39,35.39,0,0,1,23.81,2.6l-.33.08a35.68,35.68,0,0,1,24.62-14.38,32.79,32.79,0,0,1,11.14.54,34.78,34.78,0,0,1,9.12,3.38,35.16,35.16,0,0,1,10.81,8.91,20.91,20.91,0,0,1,1.33,1.76,14.27,14.27,0,0,1,.9,1.35c.21.36.38.64.51.85A2.41,2.41,0,0,1,385.52,202.71Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M396.29,195.47c-.06.08-.78-.45-2.1-.94a11.21,11.21,0,0,0-2.38-.58,12.64,12.64,0,0,0-3,0,12.79,12.79,0,0,0-2.9.8,11.1,11.1,0,0,0-2.14,1.2c-1.14.83-1.69,1.53-1.76,1.47s.09-.21.33-.54a7.14,7.14,0,0,1,1.21-1.22,9.53,9.53,0,0,1,2.17-1.35,11,11,0,0,1,6.16-.85,9.59,9.59,0,0,1,2.46.72,6.68,6.68,0,0,1,1.49.86C396.15,195.3,396.31,195.45,396.29,195.47Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M412,216.54s-.57-.28-1.64-.66a12.15,12.15,0,0,0-4.75-.68,11.31,11.31,0,0,0-6.62,2.56,11.85,11.85,0,0,0-4.21,7.67l-.05.42-.34-.23a18.14,18.14,0,0,0-3.67-1.8,18.72,18.72,0,0,0-10.33-.65,18.52,18.52,0,0,0-7.61,3.81,19.44,19.44,0,0,0-3.84,4.33c-.74,1.16-1.06,1.86-1.1,1.83a2.1,2.1,0,0,1,.2-.52,12.23,12.23,0,0,1,.73-1.42,18.47,18.47,0,0,1,11.51-8.49,18.75,18.75,0,0,1,14.39,2.48l-.4.19a12.21,12.21,0,0,1,4.43-8,11.56,11.56,0,0,1,6.9-2.55,11.79,11.79,0,0,1,4.83.84,8.69,8.69,0,0,1,1.19.59A1.66,1.66,0,0,1,412,216.54Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M455.22,157.67a5,5,0,0,1,.41.7c.24.47.62,1.16,1.05,2.07a46.26,46.26,0,0,1,2.8,8.05A54.35,54.35,0,0,1,461,181a64.17,64.17,0,0,1-.38,7.46,71.57,71.57,0,0,1-1.28,7.92,82.49,82.49,0,0,1-10.46,26,47.72,47.72,0,0,1-5.1,6.83c-.69.73-1.24,1.29-1.64,1.64a4.44,4.44,0,0,1-.62.52,5.6,5.6,0,0,1,.55-.6c.38-.37.89-.95,1.56-1.7a52.28,52.28,0,0,0,4.94-6.88,85.05,85.05,0,0,0,10.26-25.9,70.94,70.94,0,0,0,1.28-7.86,63.54,63.54,0,0,0,.41-7.41,56,56,0,0,0-1.39-12.46,50.85,50.85,0,0,0-2.63-8c-.39-.92-.75-1.61-1-2.1A5.11,5.11,0,0,1,455.22,157.67Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M427.56,159a5,5,0,0,1,.93,1,19.67,19.67,0,0,1,2.07,3,21.88,21.88,0,0,1-.74,22.94,19.72,19.72,0,0,1-2.25,2.85,5.52,5.52,0,0,1-1,.9,43.56,43.56,0,0,0,2.93-3.95,22.43,22.43,0,0,0,.73-22.56A38.61,38.61,0,0,0,427.56,159Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M390.9,132.17a35.39,35.39,0,0,0,9.75,9.91,3.17,3.17,0,0,0,4.75-3.69l0-.08a129.6,129.6,0,0,0,14.27,9.51,3.9,3.9,0,0,0,5.63-4.72,59.82,59.82,0,0,0-27.4-31.91Z"
                                                style="fill:currentColor"></path>
                                            <g style="opacity:0.30000000000000004">
                                                <path
                                                    d="M396.66,132.65a6,6,0,0,0,1.57,1.78,2.06,2.06,0,0,0,2.24.14c1-.67.95-2.3,2-2.92s2.41.27,3.33,1.14l2.9,2.77c.71.68,1.67,1.41,2.58,1s1.07-1.82.85-2.88a15.64,15.64,0,0,0-9.31-11.15Z">
                                                </path>
                                            </g>
                                            <path d="M435.16,156.47a3.49,3.49,0,1,0,0-.25" style="fill:currentColor">
                                            </path>
                                            <path
                                                d="M251.3,35.81c-2.82,4.39,3.35,19.73,17.49,39.37a133.92,133.92,0,0,0,30,30.18l81.54,52.31,13.78-21.48,8-12.46,13.78-21.48-74-47.47A134.52,134.52,0,0,0,319,43a160.39,160.39,0,0,0-24.62-7.71c-23.55-5.17-40.27-3.87-43.08.52"
                                                style="fill:#f5f5f5"></path>
                                            <path d="M364.75,69.47l.3-.1a61,61,0,0,1,52.4,6.52l9.77,6.27L401.29,92.91Z"
                                                style="fill:currentColor"></path>
                                            <path
                                                d="M364.75,69.47l.19.12.53.33,2,1.29L375.08,76l26.29,16.76h-.14L424.86,83l2.29-1,0,.3-5.75-3.7c-1.9-1.2-3.74-2.44-5.61-3.53a61.68,61.68,0,0,0-11.28-5.3,58.75,58.75,0,0,0-10.93-2.72c-1.74-.31-3.44-.41-5.07-.58s-3.2-.18-4.7-.12a60.46,60.46,0,0,0-14,1.74c-1.64.35-2.86.79-3.71,1l-1.29.37.32-.12L366,69c.84-.25,2.06-.71,3.7-1.08a59,59,0,0,1,14.06-1.85c1.5-.07,3.08,0,4.72.1s3.34.26,5.09.56a59.19,59.19,0,0,1,11,2.7,62,62,0,0,1,11.35,5.31c1.89,1.1,3.72,2.33,5.62,3.54L427.31,82l.28.18-.31.13-2.29,1-23.64,9.79-.08,0-.07,0-26.31-17-7.5-4.86-2-1.29c-.21-.14-.38-.24-.5-.33Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M329.2,124.9s0,.15,0,.31a60.19,60.19,0,0,0,27.39,44.29l9.64,6.19-1-27.67Z"
                                                style="fill:currentColor"></path>
                                            <path
                                                d="M329.2,124.9l.16.09.5.32,2,1.24,7.44,4.73,26.05,16.6.07.05V148c.29,7.77.61,16.29.94,25.22,0,.84.06,1.68.09,2.45V176l-.28-.18-5.68-3.64c-1.86-1.21-3.72-2.35-5.48-3.59a60.54,60.54,0,0,1-9.43-8,57.52,57.52,0,0,1-6.93-8.74c-1-1.44-1.79-2.94-2.61-4.34s-1.47-2.81-2-4.19A58.5,58.5,0,0,1,329.88,130c-.33-1.62-.43-2.9-.55-3.76-.05-.42-.09-.74-.12-1s0-.33,0-.33c0,.19.08.55.2,1.3s.26,2.14.61,3.75a59.92,59.92,0,0,0,4.21,13.29c.57,1.37,1.32,2.72,2,4.17s1.62,2.87,2.61,4.3a57.92,57.92,0,0,0,6.93,8.68,61,61,0,0,0,9.39,7.94c1.75,1.22,3.62,2.36,5.48,3.57l5.68,3.64-.27.15c0-.77-.05-1.61-.09-2.44-.32-8.93-.63-17.46-.91-25.23l.07.13-25.84-16.68-7.43-4.82-2-1.29-.51-.34Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M251.3,35.81c-2.31,3.31,1,13.34,9.12,26.76L282.35,33C266.58,31.07,254.25,31.56,251.3,35.81Z"
                                                style="fill:currentColor"></path>
                                            <line x1="367.37" y1="149.38" x2="402.24" y2="94.31"
                                                style="fill:#f5f5f5"></line>
                                            <path
                                                d="M402.24,94.31c.08.06-7.66,12.43-17.29,27.63s-17.5,27.5-17.58,27.44S375,137,384.66,121.76,402.16,94.26,402.24,94.31Z"
                                                style="fill:#263238"></path>
                                            <line x1="369.68" y1="151.21" x2="404.55" y2="96.15"
                                                style="fill:#f5f5f5"></line>
                                            <path
                                                d="M404.55,96.15c.08,0-7.66,12.42-17.29,27.62s-17.5,27.5-17.58,27.44,7.66-12.41,17.29-27.62S404.47,96.09,404.55,96.15Z"
                                                style="fill:#263238"></path>
                                            <line x1="372.32" y1="152.84" x2="407.19" y2="97.77"
                                                style="fill:#f5f5f5"></line>
                                            <path
                                                d="M407.19,97.77c.08.06-7.66,12.43-17.29,27.63s-17.5,27.5-17.58,27.44,7.66-12.41,17.29-27.62S407.11,97.72,407.19,97.77Z"
                                                style="fill:#263238"></path>
                                            <line x1="374.95" y1="154.47" x2="409.83" y2="99.4"
                                                style="fill:#f5f5f5"></line>
                                            <path
                                                d="M409.83,99.4c.08.06-7.67,12.43-17.29,27.63S375,154.52,375,154.47s7.66-12.41,17.29-27.62S409.74,99.35,409.83,99.4Z"
                                                style="fill:#263238"></path>
                                            <line x1="377.59" y1="156.1" x2="412.46" y2="101.03"
                                                style="fill:#f5f5f5"></line>
                                            <path
                                                d="M412.46,101c.08,0-7.66,12.42-17.29,27.63s-17.5,27.49-17.58,27.44,7.66-12.41,17.29-27.62S412.38,101,412.46,101Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M347.1,97.12s.15,0,.42.18.65.36,1.15.64c1,.58,2.39,1.45,4.11,2.54,3.45,2.17,8.18,5.23,13.38,8.64s9.89,6.52,13.28,8.79l4,2.71,1.07.75a1.57,1.57,0,0,1,.36.28,3,3,0,0,1-.4-.23l-1.11-.69-4.06-2.62L366,109.4l-13.32-8.72-4-2.62c-.48-.3-.85-.56-1.11-.7Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M364.75,69.47c.08.06-7.74,12.41-17.46,27.58s-17.67,27.45-17.75,27.4,7.74-12.4,17.46-27.58S364.67,69.42,364.75,69.47Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M376.84,109.92a.84.84,0,0,1,0-.49,2,2,0,0,1,.64-1.19,2,2,0,0,1,1.94-.49,2.12,2.12,0,0,1,.37,4,2,2,0,0,1-2-.12,2.08,2.08,0,0,1-.86-1c-.1-.3-.08-.49-.06-.49s.05.17.19.44a2.07,2.07,0,0,0,.85.89,1.74,1.74,0,0,0,1.73,0,1.82,1.82,0,0,0-.32-3.39,1.74,1.74,0,0,0-1.68.36,2.08,2.08,0,0,0-.68,1C376.87,109.75,376.87,109.92,376.84,109.92Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M361.27,99.52s-.07-.17,0-.49a2,2,0,0,1,.64-1.19,2,2,0,0,1,1.94-.49,2.12,2.12,0,0,1,.37,4,2,2,0,0,1-2-.12,2.11,2.11,0,0,1-.85-1,1,1,0,0,1-.07-.49s.06.17.2.44a2.07,2.07,0,0,0,.85.89,1.72,1.72,0,0,0,1.72,0,1.82,1.82,0,0,0-.31-3.39,1.76,1.76,0,0,0-1.69.36,2.12,2.12,0,0,0-.67,1C361.3,99.35,361.3,99.52,361.27,99.52Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M331.28,92.28a1,1,0,0,1,0-.49,2.1,2.1,0,0,1,.64-1.19,2,2,0,0,1,2-.49,2.12,2.12,0,0,1,.36,4,2,2,0,0,1-2-.12,2.05,2.05,0,0,1-.85-1c-.11-.31-.09-.49-.07-.49a4,4,0,0,1,.19.44,2.19,2.19,0,0,0,.85.89,1.76,1.76,0,0,0,1.73,0,2,2,0,0,0,1-1.81,1.93,1.93,0,0,0-1.34-1.58,1.74,1.74,0,0,0-1.68.36,2.08,2.08,0,0,0-.68,1C331.31,92.11,331.31,92.28,331.28,92.28Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M317.93,89c.06-.07,5.78,3.08,12.78,7s12.62,7.25,12.56,7.33-5.78-3.08-12.78-7S317.88,89.11,317.93,89Z"
                                                style="fill:#263238"></path>
                                            <g style="opacity:0.30000000000000004">
                                                <path
                                                    d="M364.3,147.41S341,131.69,329.2,124.9c4.07,5.83,8.76,12.45,14.41,16.77A29.69,29.69,0,0,0,364.3,147.41Z">
                                                </path>
                                            </g>
                                            <circle cx="307.51" cy="72.44" r="19.72"
                                                transform="translate(151.32 347.06) rotate(-73.63)" style="fill:#fff">
                                            </circle>
                                            <path
                                                d="M327.2,73.57a1.34,1.34,0,0,1,0-.32c0-.24,0-.55,0-.94a9.76,9.76,0,0,0-.09-1.52,14.93,14.93,0,0,0-.3-2.05,19.22,19.22,0,0,0-1.9-5.32,19.74,19.74,0,0,0-4.67-5.81,19.47,19.47,0,0,0-18.27-3.81,18.26,18.26,0,0,0-5.07,2.37,22.62,22.62,0,0,0-2.31,1.75,24.19,24.19,0,0,0-2,2.14,19.4,19.4,0,0,0-1.31,23A23,23,0,0,0,293,85.4a20.76,20.76,0,0,0,2.1,2,18.3,18.3,0,0,0,4.77,2.94A19.61,19.61,0,0,0,310,91.78a19.64,19.64,0,0,0,13.71-8.4,19,19,0,0,0,2.49-5.07,16.5,16.5,0,0,0,.54-2,9.67,9.67,0,0,0,.26-1.5c.05-.38.09-.69.13-.93a1.24,1.24,0,0,1,.06-.31,1.93,1.93,0,0,1,0,.32c0,.24-.05.55-.08.93a9.1,9.1,0,0,1-.21,1.52,14.87,14.87,0,0,1-.5,2A18.37,18.37,0,0,1,324,83.54a19.85,19.85,0,0,1-13.89,8.67,20,20,0,0,1-10.42-1.43,18.75,18.75,0,0,1-4.9-3,18.58,18.58,0,0,1-4-4.47,19.44,19.44,0,0,1-2.54-5.66,21.09,21.09,0,0,1-.67-6.36,20,20,0,0,1,4.56-11.56,20.73,20.73,0,0,1,2.09-2.2,23.75,23.75,0,0,1,2.37-1.79,18.84,18.84,0,0,1,5.2-2.41,20,20,0,0,1,10.51-.24,19.88,19.88,0,0,1,12.83,10.19A18.85,18.85,0,0,1,327,68.7a12.52,12.52,0,0,1,.26,2.08,9.23,9.23,0,0,1,.05,1.53c0,.39,0,.7,0,.94A1.34,1.34,0,0,1,327.2,73.57Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M251.3,35.81a2.07,2.07,0,0,1,.13-.19,2.57,2.57,0,0,1,.45-.52,7.46,7.46,0,0,1,2.3-1.41,31.46,31.46,0,0,1,10.26-1.79,98.69,98.69,0,0,1,16.59.89,154.81,154.81,0,0,1,21.69,4.44q5.94,1.7,12.31,4a139,139,0,0,1,13,5.49,137.32,137.32,0,0,1,13.24,7.38l13.58,8.69L416,102l.22.14-.14.22c-5.71,8.89-11.69,18.21-17.77,27.71s-12.08,18.81-17.79,27.71l-.13.22-.22-.14L319,118.63l-13.56-8.72L299,105.75c-2.11-1.42-4.06-3-6-4.51a143.31,143.31,0,0,1-19.09-19.11A172.67,172.67,0,0,1,261.16,64a110.1,110.1,0,0,1-7.75-14.69,32.19,32.19,0,0,1-2.81-10,7.31,7.31,0,0,1,.29-2.68,2.71,2.71,0,0,1,.29-.63,1.13,1.13,0,0,1,.12-.2,4.25,4.25,0,0,0-.36.84,7.46,7.46,0,0,0-.24,2.66,32.67,32.67,0,0,0,2.88,10,111.62,111.62,0,0,0,7.81,14.62,174.44,174.44,0,0,0,12.8,18,142.94,142.94,0,0,0,19.09,19c1.88,1.53,3.84,3.08,5.92,4.47l6.48,4.15,13.57,8.7,61.18,39.2-.36.08,17.78-27.71,17.77-27.71.08.36L354.57,63.21,341,54.51a137.87,137.87,0,0,0-13.18-7.39c-4.37-2.14-8.71-3.93-12.93-5.5s-8.32-2.93-12.27-4.06A154.79,154.79,0,0,0,281,33.06a99.31,99.31,0,0,0-16.54-1,31.94,31.94,0,0,0-10.23,1.7,7.75,7.75,0,0,0-2.31,1.35A6.35,6.35,0,0,0,251.3,35.81Z"
                                                style="fill:#263238"></path>
                                        </g>
                                        <g id="freepik--search-bar--inject-66">
                                            <path
                                                d="M332.05,262.17H158.38a20.53,20.53,0,0,1-20.53-20.53h0a20.53,20.53,0,0,1,20.53-20.53H332.05a20.53,20.53,0,0,1,20.53,20.53h0A20.53,20.53,0,0,1,332.05,262.17Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M332.05,262.17l1.22-.09a9.22,9.22,0,0,0,1.5-.15,16.45,16.45,0,0,0,2.05-.39l1.22-.32c.42-.14.85-.31,1.31-.48l.7-.26.71-.35a12.23,12.23,0,0,0,1.47-.77,20.13,20.13,0,0,0,5.95-5.22,15.66,15.66,0,0,0,1.31-1.91,16.78,16.78,0,0,0,1.13-2.15,23.07,23.07,0,0,0,.92-2.38c.11-.42.22-.84.33-1.28l.17-.65.1-.67.21-1.37.06-1.4,0-.72,0-.72c0-.49,0-1-.09-1.47a21.72,21.72,0,0,0-1.59-5.92,20.71,20.71,0,0,0-9.06-9.81,20.25,20.25,0,0,0-7-2.23c-2.52-.28-5.17-.14-7.86-.17l-168.39.08a22.77,22.77,0,0,0-6,.89,22.21,22.21,0,0,0-5.42,2.61,21.89,21.89,0,0,0-4.38,4,21.07,21.07,0,0,0-3,5.11,21.38,21.38,0,0,0-1.4,5.72,21.89,21.89,0,0,0,.3,5.83,20.2,20.2,0,0,0,5.29,10.12,20.16,20.16,0,0,0,9.73,5.61,21.58,21.58,0,0,0,2.76.5c.94,0,1.86.13,2.81.11h27.5l75.71.06,51,.08,13.88.05,3.61,0,1.23,0-1.23,0-3.61,0-13.88,0-51,.09-75.71.05h-27.5c-.94,0-1.91-.07-2.86-.11a22.68,22.68,0,0,1-2.83-.51,20.66,20.66,0,0,1-10-5.74,21.52,21.52,0,0,1-3.46-4.78,22,22,0,0,1-2-5.6,22.59,22.59,0,0,1-.3-6,20.8,20.8,0,0,1,4.51-11.11,20.75,20.75,0,0,1,10.06-6.82,23,23,0,0,1,6.13-.92l168.39.07c2.69,0,5.32-.1,7.9.2a20.26,20.26,0,0,1,7.15,2.28,21,21,0,0,1,9.17,10,21.79,21.79,0,0,1,1.59,6c.05.5.05,1,.08,1.49l0,.73,0,.72c0,.48-.05,1-.07,1.43s-.15.93-.22,1.38l-.1.68-.17.66c-.12.44-.23.87-.34,1.29-.33.82-.55,1.66-.94,2.41a17.88,17.88,0,0,1-1.16,2.17,16.6,16.6,0,0,1-1.33,1.91,20.28,20.28,0,0,1-6,5.24,15,15,0,0,1-1.49.76l-.72.34-.7.26c-.47.17-.9.34-1.33.47l-1.22.31a15,15,0,0,1-2.07.37,10.23,10.23,0,0,1-1.5.13Z"
                                                style="fill:#263238"></path>
                                            <circle cx="324.17" cy="240.52" r="9.14"
                                                transform="translate(-75.12 299.67) rotate(-45)" style="fill:#fff">
                                            </circle>
                                            <path
                                                d="M324.17,250.15a9.64,9.64,0,1,1,9.63-9.63A9.64,9.64,0,0,1,324.17,250.15Zm0-18.27a8.64,8.64,0,1,0,8.63,8.64A8.64,8.64,0,0,0,324.17,231.88Z"
                                                style="fill:#263238"></path>
                                            <rect x="334.9" y="243.78" width="1" height="9.15"
                                                transform="translate(-53.66 399.36) rotate(-57.73)" style="fill:#263238">
                                            </rect>
                                        </g>
                                        <g id="freepik--Text--inject-66">
                                            <path
                                                d="M166.69,245l.75-1.68a5.66,5.66,0,0,0,3.17,1c1.31,0,1.85-.43,1.85-1,0-1.8-5.58-.57-5.58-4.13,0-1.63,1.32-3,4-3a6.44,6.44,0,0,1,3.33.84l-.68,1.69a5.38,5.38,0,0,0-2.66-.75c-1.32,0-1.82.49-1.82,1.09,0,1.77,5.57.55,5.57,4.07,0,1.61-1.33,3-4.07,3A6.88,6.88,0,0,1,166.69,245Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M183.21,242.83h-5.58a2,2,0,0,0,2.11,1.48,2.49,2.49,0,0,0,1.85-.71l1.14,1.23a3.85,3.85,0,0,1-3,1.19c-2.55,0-4.21-1.6-4.21-3.79a3.76,3.76,0,0,1,3.94-3.8,3.64,3.64,0,0,1,3.83,3.82C183.25,242.42,183.22,242.65,183.21,242.83Zm-5.6-1.25h3.63a1.84,1.84,0,0,0-3.63,0Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M191,241.7v4.21h-2V245a2.43,2.43,0,0,1-2.25,1c-1.72,0-2.75-1-2.75-2.23s.92-2.21,3.16-2.21h1.7c0-.92-.55-1.45-1.7-1.45a3.55,3.55,0,0,0-2.12.68l-.77-1.49a5.63,5.63,0,0,1,3.18-.89C189.69,238.43,191,239.47,191,241.7Zm-2.14,1.88v-.75h-1.46c-1,0-1.32.37-1.32.86s.45.89,1.21.89A1.57,1.57,0,0,0,188.85,243.58Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M197.5,238.43v2l-.48,0a1.81,1.81,0,0,0-2,2.05v3.48h-2.14v-7.37h2v1A3,3,0,0,1,197.5,238.43Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M198.15,242.23a3.81,3.81,0,0,1,4.11-3.8,3.37,3.37,0,0,1,3.3,1.88l-1.65.89a1.85,1.85,0,0,0-1.66-1,2,2,0,0,0,0,4.09,1.81,1.81,0,0,0,1.66-1l1.65.91a3.41,3.41,0,0,1-3.3,1.86A3.81,3.81,0,0,1,198.15,242.23Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M214.28,241.69v4.22h-2.14V242c0-1.19-.55-1.74-1.5-1.74s-1.76.63-1.76,2v3.64h-2.14V235.74h2.14v3.57a3.2,3.2,0,0,1,2.34-.88C213,238.43,214.28,239.44,214.28,241.69Z"
                                                style="fill:#263238"></path>
                                            <path d="M215.68,244.68a1.33,1.33,0,0,1,2.66,0,1.33,1.33,0,1,1-2.66,0Z"
                                                style="fill:#263238">
                                            </path>
                                            <path d="M219.27,244.68a1.33,1.33,0,0,1,2.66,0,1.33,1.33,0,1,1-2.66,0Z"
                                                style="fill:#263238">
                                            </path>
                                            <path d="M222.86,244.68a1.33,1.33,0,0,1,2.66,0,1.33,1.33,0,1,1-2.66,0Z"
                                                style="fill:#263238">
                                            </path>
                                        </g>
                                        <g id="freepik--Document--inject-66">
                                            <path
                                                d="M100.92,100.08l-32.24-17a4.55,4.55,0,0,1-1.9-6.16L90.34,32.26a4.58,4.58,0,0,1,6.17-1.91L117,41.15l7.21,24.67L107.09,98.17A4.58,4.58,0,0,1,100.92,100.08Z"
                                                style="fill:currentColor"></path>
                                            <g style="opacity:0.30000000000000004">
                                                <path d="M117,41.15l-6.64,12.56a4.26,4.26,0,0,0,1.77,5.74l12.08,6.37Z"
                                                    style="fill:#fff">
                                                </path>
                                            </g>
                                            <g style="opacity:0.2">
                                                <path
                                                    d="M109.91,54.9a4.72,4.72,0,0,0,1.17,5.8l.35.29c1.43,1.12,10.83,8.45,11,8.21s1.78-3.38,1.78-3.38l-12.08-6.37S109.13,57.75,109.91,54.9Z">
                                                </path>
                                            </g>
                                            <path
                                                d="M107.89,51.77c-.09.16-3.49-1.47-7.61-3.65S92.89,44.06,93,43.89s3.5,1.47,7.62,3.65S108,51.61,107.89,51.77Z"
                                                style="fill:#fafafa"></path>
                                            <path
                                                d="M113.77,64c-.08.16-5.65-2.61-12.43-6.19S89.14,51.16,89.22,51s5.65,2.61,12.43,6.19S113.86,63.8,113.77,64Z"
                                                style="fill:#fafafa"></path>
                                            <path
                                                d="M112.85,71.06c-.08.16-6.14-2.87-13.53-6.78S86,57.09,86.09,56.93s6.15,2.87,13.54,6.77S112.94,70.9,112.85,71.06Z"
                                                style="fill:#fafafa"></path>
                                            <path
                                                d="M109.9,76.65c-.09.16-6.15-2.87-13.54-6.77s-13.31-7.2-13.22-7.36,6.14,2.87,13.53,6.77S110,76.49,109.9,76.65Z"
                                                style="fill:#fafafa"></path>
                                            <path
                                                d="M106.94,82.25c-.08.16-6.14-2.87-13.53-6.78S80.1,68.28,80.18,68.12,86.33,71,93.72,74.89,107,82.09,106.94,82.25Z"
                                                style="fill:#fafafa"></path>
                                            <path
                                                d="M104,87.84c-.09.16-6.15-2.87-13.53-6.77s-13.32-7.2-13.23-7.36,6.14,2.87,13.53,6.77S104.08,87.68,104,87.84Z"
                                                style="fill:#fafafa"></path>
                                        </g>
                                        <g id="freepik--Folders--inject-66">
                                            <path
                                                d="M259.84,435.62a5.2,5.2,0,0,1-4.41-5.88L261.86,385a4.32,4.32,0,0,1,5-3.49l4.2.61a4.5,4.5,0,0,0,4.34-1.82l1.17-1.71a4.5,4.5,0,0,1,4.34-1.82l20,2.87a4.52,4.52,0,0,1,3.5,2.57l.76,1.7a4.52,4.52,0,0,0,3.49,2.57l25.45,3.66a4.31,4.31,0,0,1,3.81,4.75l-6.58,45.75a5.19,5.19,0,0,1-5.88,4.4Z"
                                                style="fill:#455a64"></path>
                                            <g style="opacity:0.30000000000000004">
                                                <path
                                                    d="M259.84,435.62a5.2,5.2,0,0,1-4.41-5.88L261.86,385a4.32,4.32,0,0,1,5-3.49l4.2.61a4.5,4.5,0,0,0,4.34-1.82l1.17-1.71a4.5,4.5,0,0,1,4.34-1.82l20,2.87a4.52,4.52,0,0,1,3.5,2.57l.76,1.7a4.52,4.52,0,0,0,3.49,2.57l25.45,3.66a4.31,4.31,0,0,1,3.81,4.75l-6.58,45.75a5.19,5.19,0,0,1-5.88,4.4Z">
                                                </path>
                                            </g>
                                            <path
                                                d="M306.11,386.13l-16.18-2.37-1.06-2.91a5.65,5.65,0,0,0-4.54-3.58L268.51,375a5,5,0,0,0-5.79,4l-.26,1.85-7,48.57a5.69,5.69,0,0,0,5,6.26L324.77,445a5.68,5.68,0,0,0,6.57-4.59l6.6-45.88a3.73,3.73,0,0,0-3.17-4.24Z"
                                                style="fill:#455a64"></path>
                                            <rect x="279.47" y="403.27" width="38.65" height="16.26"
                                                transform="translate(61.6 -38.34) rotate(8.18)" style="fill:#fff"></rect>
                                            <path
                                                d="M312.17,412.35c0,.14-5.92-.59-13.18-1.63s-13.13-2-13.1-2.15,5.92.59,13.18,1.63S312.19,412.21,312.17,412.35Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M311.68,415.78c0,.14-5.92-.59-13.18-1.63s-13.13-2-13.11-2.15,5.92.59,13.18,1.63S311.7,415.64,311.68,415.78Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M375.93,415.74a3.42,3.42,0,0,1-4.41-2l-10.6-27.7a2.82,2.82,0,0,1,1.75-3.59l2.6-1a3,3,0,0,0,1.91-2.43l.12-1.35a2.94,2.94,0,0,1,1.91-2.43l12.36-4.74a3,3,0,0,1,2.83.36l1,.73a3,3,0,0,0,2.82.36l15.76-6a2.84,2.84,0,0,1,3.71,1.51l10.84,28.33a3.41,3.41,0,0,1-2,4.41Z"
                                                style="fill:currentColor"></path>
                                            <g style="opacity:0.30000000000000004">
                                                <path
                                                    d="M375.93,415.74a3.42,3.42,0,0,1-4.41-2l-10.6-27.7a2.82,2.82,0,0,1,1.75-3.59l2.6-1a3,3,0,0,0,1.91-2.43l.12-1.35a2.94,2.94,0,0,1,1.91-2.43l12.36-4.74a3,3,0,0,1,2.83.36l1,.73a3,3,0,0,0,2.82.36l15.76-6a2.84,2.84,0,0,1,3.71,1.51l10.84,28.33a3.41,3.41,0,0,1-2,4.41Z">
                                                </path>
                                            </g>
                                            <path
                                                d="M386.65,372.57l-10,3.82-1.54-1.33a3.67,3.67,0,0,0-3.74-.6l-9.8,3.75a3.28,3.28,0,0,0-2,4.17l.44,1.14,11.51,30.08a3.75,3.75,0,0,0,4.88,2l39.81-15.24a3.73,3.73,0,0,0,2.31-4.74l-10.88-28.42a2.46,2.46,0,0,0-3.18-1.41Z"
                                                style="fill:currentColor"></path>
                                            <rect x="377.84" y="384.06" width="25.37" height="10.67"
                                                transform="translate(-113.4 165.34) rotate(-20.95)" style="fill:#fff">
                                            </rect>
                                            <path
                                                d="M398.5,385.67a71.49,71.49,0,0,1-8.05,3.36,71.42,71.42,0,0,1-8.23,2.87,76.21,76.21,0,0,1,8-3.36A73.8,73.8,0,0,1,398.5,385.67Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M399.31,387.8a75.36,75.36,0,0,1-8,3.35A73.27,73.27,0,0,1,383,394a71.49,71.49,0,0,1,8.05-3.36A72.17,72.17,0,0,1,399.31,387.8Z"
                                                style="fill:#263238"></path>
                                        </g>
                                        <g id="freepik--Plant--inject-66">
                                            <path
                                                d="M415.84,433a8.25,8.25,0,0,1,4.24,4.8,14.48,14.48,0,0,1,.56,6.51c-.48,4.22-2.88,8.49-5.46,11.86-3.56-3.1-4.38-8.52-4.62-11.29-.38-4.38,1.59-12.53,5.28-11.88"
                                                style="fill:currentColor"></path>
                                            <path
                                                d="M419.31,463.15a7,7,0,0,1,2.26-6.64,9.26,9.26,0,0,1,6.84-2.13,3.86,3.86,0,0,1,3,1.35,3,3,0,0,1,0,3,6.09,6.09,0,0,1-2.24,2.21c-3.08,1.93-6.41,3.24-9.9,2.19"
                                                style="fill:currentColor"></path>
                                            <path
                                                d="M414.75,476.1a5.18,5.18,0,0,1,.13-.87c.11-.61.25-1.4.43-2.34a24.58,24.58,0,0,1,2.42-7.5,15,15,0,0,1,5.37-5.71,10.14,10.14,0,0,1,2.2-1c.27-.09.48-.12.63-.16a.61.61,0,0,1,.22,0,16.5,16.5,0,0,0-2.93,1.35,15.47,15.47,0,0,0-5.22,5.67,26.32,26.32,0,0,0-2.48,7.39c-.21,1-.39,1.78-.52,2.33A5.11,5.11,0,0,1,414.75,476.1Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M414.89,439.35a2.28,2.28,0,0,1,0,.38l.06,1.09c.05.94.11,2.31.16,4,.11,3.39.2,8.06.18,13.23s-.15,9.84-.29,13.23c-.07,1.69-.14,3.06-.2,4,0,.45,0,.81-.07,1.09a1.65,1.65,0,0,1,0,.38,2.39,2.39,0,0,1,0-.39v-1.09c0-1,.06-2.34.1-4,.09-3.38.18-8.06.2-13.22s0-9.84-.08-13.22c0-1.66-.05-3-.07-4v-1.09A1.59,1.59,0,0,1,414.89,439.35Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M413.16,465.72a16.31,16.31,0,0,0-8.92-12c-1.19-.57-2.74-.94-3.71-.06s-.76,2.47-.28,3.7a14,14,0,0,0,12.83,8.67"
                                                style="fill:currentColor"></path>
                                            <path
                                                d="M404.82,457.76a4,4,0,0,1,.75.33,9.6,9.6,0,0,1,.86.46c.31.2.7.39,1.08.68a12.91,12.91,0,0,1,1.24.93,17.72,17.72,0,0,1,1.32,1.2,18.45,18.45,0,0,1,2.52,3.23,18.05,18.05,0,0,1,1.65,3.74,16.17,16.17,0,0,1,.42,1.74,13.14,13.14,0,0,1,.21,1.54,11.94,11.94,0,0,1,.06,1.28,7,7,0,0,1,0,1,4.61,4.61,0,0,1-.09.82c-.07,0,.05-1.17-.16-3a13,13,0,0,0-.24-1.51c-.1-.55-.27-1.11-.44-1.71a17.4,17.4,0,0,0-4.1-6.85,15.52,15.52,0,0,0-1.28-1.2,14.55,14.55,0,0,0-1.2-.95C405.86,458.31,404.79,457.82,404.82,457.76Z"
                                                style="fill:#263238"></path>
                                        </g>
                                        <g id="freepik--Character--inject-66">
                                            <path
                                                d="M116.7,448.64l-.61,29.08,38.28.9c-.13-3.46-19.75-10.87-19.75-10.87l1.2-18.61Z"
                                                style="fill:#455a64"></path>
                                            <g style="opacity:0.6000000000000001">
                                                <path
                                                    d="M122.82,465.91a1.48,1.48,0,0,0-1.12,1.66,1.5,1.5,0,0,0,1.73,1.07,1.41,1.41,0,1,0-.75-2.69"
                                                    style="fill:#fff"></path>
                                            </g>
                                            <g style="opacity:0.6000000000000001">
                                                <path d="M116.09,477.72l.19-2.93,36.63,2s1.68.74,1.46,1.87Z"
                                                    style="fill:#fff"></path>
                                            </g>
                                            <path
                                                d="M135.24,467.58c0,.18-.94.24-1.88.79s-1.44,1.27-1.61,1.2.13-1.09,1.28-1.73S135.29,467.42,135.24,467.58Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M139.22,469.25c0,.17-.78.45-1.44,1.18s-.86,1.52-1,1.51-.28-1,.55-1.91S139.22,469.08,139.22,469.25Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M141.38,473.84c-.17,0-.41-.85.09-1.81s1.39-1.32,1.47-1.17-.48.65-.88,1.44S141.56,473.83,141.38,473.84Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M135,463.31c-.08.16-.94-.1-2-.06s-1.89.34-2,.19.72-.77,2-.8S135.11,463.18,135,463.31Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M134.22,459a3.8,3.8,0,0,1-1.92-.05,9.18,9.18,0,0,1-2-.63,9.48,9.48,0,0,1-1.08-.58,2.37,2.37,0,0,1-.57-.44.73.73,0,0,1-.06-.94,1,1,0,0,1,.83-.39,2.79,2.79,0,0,1,.71.11,7,7,0,0,1,1.19.42,6.57,6.57,0,0,1,1.73,1.14c.87.79,1.16,1.46,1.09,1.49s-.5-.5-1.39-1.17a7.91,7.91,0,0,0-1.68-.95,8.35,8.35,0,0,0-1.1-.34c-.4-.11-.74-.12-.85,0s0,.09,0,.21a1.88,1.88,0,0,0,.41.32,11.48,11.48,0,0,0,1,.57,10.09,10.09,0,0,0,1.84.71A13,13,0,0,1,134.22,459Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M134,459.25a2.79,2.79,0,0,1-.46-1.76,5.52,5.52,0,0,1,.31-2,6,6,0,0,1,.52-1.09,1.61,1.61,0,0,1,1.25-.89.92.92,0,0,1,.79.53,2.06,2.06,0,0,1,.17.67,3.81,3.81,0,0,1,0,1.22,4.14,4.14,0,0,1-.86,1.85c-.78.92-1.56,1.11-1.58,1.05s.6-.41,1.2-1.3a4.1,4.1,0,0,0,.65-1.69,3.37,3.37,0,0,0,0-1.05c0-.38-.19-.7-.34-.66s-.53.27-.69.58a6,6,0,0,0-.5,1,6.1,6.1,0,0,0-.42,1.8C133.89,458.56,134.07,459.22,134,459.25Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M87.69,451.06,84,479.91l-38-4.72c.64-3.4,21.13-7.85,21.13-7.85l1.54-18.59Z"
                                                style="fill:#455a64"></path>
                                            <g style="opacity:0.6000000000000001">
                                                <path
                                                    d="M79.11,467.24a1.48,1.48,0,0,1,.87,1.81,1.51,1.51,0,0,1-1.87.8,1.55,1.55,0,0,1-.91-1.92,1.59,1.59,0,0,1,2-.63"
                                                    style="fill:#fff"></path>
                                            </g>
                                            <g style="opacity:0.6000000000000001">
                                                <path d="M84,479.91l.25-2.93-36.52-3.42S46,474,46,475.19Z"
                                                    style="fill:#fff"></path>
                                            </g>
                                            <path
                                                d="M66.58,467.08c0,.18.9.37,1.75,1.05s1.24,1.47,1.42,1.42,0-1.09-1-1.89S66.56,466.91,66.58,467.08Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M62.41,468.14c-.07.17.7.57,1.24,1.39s.63,1.62.81,1.64.43-1-.26-2S62.43,468,62.41,468.14Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M59.6,472.37c.16.06.52-.78.16-1.8s-1.18-1.51-1.27-1.38.38.72.66,1.56S59.41,472.33,59.6,472.37Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M67.43,462.89c.06.17.94,0,2,.23s1.82.61,1.93.47-.59-.86-1.82-1.08S67.35,462.74,67.43,462.89Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M68.85,458.74a3.8,3.8,0,0,0,1.9.22,8.35,8.35,0,0,0,2.06-.33,8.06,8.06,0,0,0,1.16-.41,2.38,2.38,0,0,0,.63-.35.74.74,0,0,0,.2-.92,1.06,1.06,0,0,0-.77-.51,2.83,2.83,0,0,0-.72,0,6.54,6.54,0,0,0-1.23.24,6.65,6.65,0,0,0-1.89.87c-1,.66-1.35,1.28-1.29,1.32s.57-.43,1.54-.95a7.32,7.32,0,0,1,2.94-.88c.42-.05.76,0,.84.17s0,.1-.07.2a1.76,1.76,0,0,1-.46.25,8.44,8.44,0,0,1-1.07.42,11.23,11.23,0,0,1-1.92.44A12.27,12.27,0,0,0,68.85,458.74Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M69.06,459a2.8,2.8,0,0,0,.71-1.68,5.62,5.62,0,0,0,0-2,5.37,5.37,0,0,0-.35-1.15,1.58,1.58,0,0,0-1.1-1.06.91.91,0,0,0-.86.4,2.59,2.59,0,0,0-.27.64,3.65,3.65,0,0,0-.15,1.21,4,4,0,0,0,.58,2c.63,1,1.38,1.33,1.41,1.27s-.54-.5-1-1.46a4.13,4.13,0,0,1-.39-1.77,3.35,3.35,0,0,1,.16-1c.1-.38.29-.67.44-.61s.47.35.59.67a6.43,6.43,0,0,1,.36,1,6.77,6.77,0,0,1,.15,1.84C69.24,458.35,69,459,69.06,459Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M146.39,294.31,86.8,296.22S72.75,390,73.14,396.53l-8.66,68,25.2.89s4-22.07,6.73-37.17c1.84-10,5.2-24.78,6.11-33.17s15.65-67,15.65-67-1.09,68-1.06,70.8-2.92,66.46-2.92,66.46h25c1.29-11.49,4.36-57.47,5-66.76,1.2-16.78,5-64.18,5.51-76.29S146.39,294.31,146.39,294.31Z"
                                                style="fill:#263238"></path>
                                            <path d="M142.46,294.77a11,11,0,0,1,0-4.27,10.47,10.47,0,0,1,0,4.27Z"
                                                style="fill:#455a64"></path>
                                            <path
                                                d="M144.94,295.9a8.1,8.1,0,0,1,.45-5.4,20.54,20.54,0,0,1-.26,2.7A20.16,20.16,0,0,1,144.94,295.9Z"
                                                style="fill:#455a64"></path>
                                            <path
                                                d="M122.68,291.43a2.37,2.37,0,0,0-1.26.71,1.73,1.73,0,0,0-.41,1.41,1.63,1.63,0,0,0,2.85.54,1.77,1.77,0,0,0,.14-1.46,2.26,2.26,0,0,0-.92-1.12s.17,0,.42.11a1.79,1.79,0,0,1,.78.9,2,2,0,0,1-.08,1.78,2,2,0,0,1-3.59-.68,2,2,0,0,1,.58-1.69,1.84,1.84,0,0,1,1.06-.55C122.53,291.35,122.68,291.41,122.68,291.43Z"
                                                style="fill:#455a64"></path>
                                            <path
                                                d="M95.21,394.92a53.06,53.06,0,0,1-6.38-2.39,53.49,53.49,0,0,1-6.22-2.79A54.52,54.52,0,0,1,89,392.13,54.46,54.46,0,0,1,95.21,394.92Z"
                                                style="fill:#455a64"></path>
                                            <path
                                                d="M92,153.36c.19-3.47,2.33-5.61,5.32-7.38a10.82,10.82,0,0,1,10-.45c2.1,1,3.94,2.7,6.24,3,3.8.49,7.39-3,11.11-2.15a4.94,4.94,0,0,1-.36,9.68c2.49.36,3.89,3.51,3,5.84s-3.52,3.7-6,3.75a13.82,13.82,0,0,1-7.1-2.23c-2.17-1.26-4.2-2.78-6.47-3.86a10.76,10.76,0,0,0-7.29-1.07c-3.29.87-5.62,4-6.47,7.26s-.49,6.77,0,10.13,1.16,6.75.84,10.14a1.25,1.25,0,0,1-.48,1c-.5.28-1.08-.19-1.45-.63a49.82,49.82,0,0,1-9.38-17c-1.15-3.6-1.78-7.11-.41-10.63s6-6.87,8.94-5.44"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M88.77,170.12l5.55,34.27c1,6.4,5.2,12.59,15.24,10.49h0c8.58-2.48,7.94-8.65,6.82-16.26h0s9.44-2.45,8.59-12.05c-.4-4.64-2-14.12-3.59-22.68a17.93,17.93,0,0,0-19.44-14.61l-.93.09C91.1,151,86.91,160.26,88.77,170.12Z"
                                                style="fill:#ffbe9d"></path>
                                            <path d="M116.38,198.62a23.28,23.28,0,0,1-12.84-2.43s3.76,7.12,13.23,5.3Z"
                                                style="fill:#eb996e">
                                            </path>
                                            <path
                                                d="M119.5,172.28a1.37,1.37,0,0,1-1.18,1.51,1.3,1.3,0,0,1-1.53-1.09,1.37,1.37,0,0,1,1.18-1.51A1.31,1.31,0,0,1,119.5,172.28Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M119.8,168.8c-.15.2-1.27-.47-2.74-.31s-2.48,1-2.66.83.06-.41.49-.8a3.79,3.79,0,0,1,2.11-.89,3.53,3.53,0,0,1,2.2.48C119.69,168.41,119.87,168.71,119.8,168.8Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M106.09,174.4a1.37,1.37,0,0,1-1.18,1.51,1.3,1.3,0,0,1-1.53-1.09,1.37,1.37,0,0,1,1.18-1.51A1.31,1.31,0,0,1,106.09,174.4Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M105.63,170.53c-.16.19-1.27-.47-2.74-.32s-2.48,1-2.66.84.06-.41.49-.8a3.79,3.79,0,0,1,2.11-.89,3.62,3.62,0,0,1,2.2.47C105.52,170.13,105.7,170.44,105.63,170.53Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M111.79,180.92a9.45,9.45,0,0,1,2.35-.68c.37-.07.72-.18.76-.45a2,2,0,0,0-.36-1.09c-.45-.87-.92-1.79-1.4-2.75-2-3.92-3.41-7.16-3.25-7.24a51.11,51.11,0,0,1,3.82,7l1.36,2.78a2.23,2.23,0,0,1,.34,1.45.94.94,0,0,1-.56.62,3.13,3.13,0,0,1-.63.15A10,10,0,0,1,111.79,180.92Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M105.15,164.72c-.1.42-1.59.38-3.3.76s-3.06,1-3.32.66c-.12-.17.08-.57.61-1a5.9,5.9,0,0,1,5-1.08C104.84,164.24,105.19,164.53,105.15,164.72Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M118.83,164.59c-.23.37-1.28.12-2.5.23s-2.23.45-2.5.12c-.12-.16,0-.51.43-.87a3.63,3.63,0,0,1,4-.28C118.75,164.09,118.93,164.42,118.83,164.59Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M90.26,177.14c-.17-.06-6.78-1.29-5.91,5.24s7.25,4.32,7.23,4.13S90.26,177.14,90.26,177.14Z"
                                                style="fill:#ffbe9d"></path>
                                            <path
                                                d="M89.26,184.3s-.1.09-.28.21a1.18,1.18,0,0,1-.85.13,2.85,2.85,0,0,1-1.64-2.36,3.7,3.7,0,0,1,.1-1.67,1.31,1.31,0,0,1,.74-1,.57.57,0,0,1,.71.22c.12.17.09.31.13.31s.12-.13,0-.39a.7.7,0,0,0-.31-.37.88.88,0,0,0-.65-.09,1.62,1.62,0,0,0-1,1.17,3.91,3.91,0,0,0-.15,1.88,3,3,0,0,0,2,2.6,1.23,1.23,0,0,0,1-.32C89.27,184.46,89.28,184.31,89.26,184.3Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M120.6,155a12.49,12.49,0,0,0-4.49-4.23,21.49,21.49,0,0,0-12.82-3.19,17.48,17.48,0,0,0-11.73,5.84,18.42,18.42,0,0,0-4.11,9.77,27.15,27.15,0,0,0,1,10.63,8.08,8.08,0,0,0,2.21,4.09c.75.64,2,1,2.67.32a2.63,2.63,0,0,0,.61-1.59c.75-5.18,1.45-10.75-.89-15.43a15.17,15.17,0,0,1,4.09-4.6,7.8,7.8,0,0,1,5.87-1.41c3,.6,5.1,3.26,7.63,5a13.89,13.89,0,0,0,12.57,1.53Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M113.09,184.89a6.49,6.49,0,0,1-.49,1.8,2.25,2.25,0,0,1-1.35,1.22,2,2,0,0,1-1.83-.55,3.19,3.19,0,0,1-.84-1.77c-.1-.6,0-1.35.59-1.55a1.68,1.68,0,0,1,.74,0l3.34.61"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M112.39,187.68a4.74,4.74,0,0,1-1.68.14,2.36,2.36,0,0,1-1.47-.87,2.5,2.5,0,0,1-.46-2,2,2,0,0,1,.17-.51c.09-.16.07-.15.21-.15a4.52,4.52,0,0,1,.53.09l.55.1,1.9.32a6,6,0,0,0,1.77.15,5.32,5.32,0,0,0-1.69-.54c-.54-.14-1.17-.28-1.88-.44l-.54-.12c-.2,0-.35-.09-.61-.11a.76.76,0,0,0-.46.11,1,1,0,0,0-.28.34,2.49,2.49,0,0,0-.22.65,2.91,2.91,0,0,0,.61,2.44,2.69,2.69,0,0,0,1.82.93A2.48,2.48,0,0,0,112,188C112.29,187.84,112.41,187.71,112.39,187.68Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M136.74,170.8l1.55-.42,24.13,23.45L182,196.19s-.2-5.91-7.55-13.45C167.85,176,152.5,168,147.3,163.86a8,8,0,0,0-2.25-1.34Z"
                                                style="fill:#ffbe9d"></path>
                                            <path
                                                d="M136.73,159.64l-2.47-.7-5.82-2.76-6.62,2.47s.15,2.26,1.89,1.64l-6.94,2.29s.57,1.65.88,1.76-4.07.47-4.07.47,0,2.23,4.15,2.19,5.76-.75,5.76-.75l3.33.89-.13,2-4.54-.07.21,2.54a53.56,53.56,0,0,0,5.84.9s7,.1,8.9-.82,4.32-2.23,4.32-2.23l3.63-6.92Z"
                                                style="fill:#ffbe9d"></path>
                                            <path
                                                d="M130.48,160.81c0,.06-.39-.13-1-.41a16,16,0,0,1-2.35-1.25h.3l-.27.17a6.74,6.74,0,0,1-2.73,1c-.74.1-1.2,0-1.2,0a15,15,0,0,0,3.66-1.4l.25-.16.15-.1.15.11c.81.56,1.66,1,2.22,1.35S130.53,160.76,130.48,160.81Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M128.35,164.34s-.45.16-1.12-.13-1.42-1-2.37-1.4l.24,0a10,10,0,0,1-1.34.76,9.49,9.49,0,0,1-3.74.92,3.42,3.42,0,0,1-1.58-.17,17,17,0,0,0,5.1-1.22,10.22,10.22,0,0,0,1.28-.71l.13-.07.11,0c1.08.55,1.71,1.28,2.3,1.58S128.35,164.26,128.35,164.34Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M134.55,166.51c0,.08-.51-.07-1.3-.06a5.43,5.43,0,0,0-2.88.87,4.93,4.93,0,0,0-1.43,1.41l-.06.09h-.09a7.69,7.69,0,0,1-2.37.29,7.54,7.54,0,0,1,2.28-.73l-.15.1a4.74,4.74,0,0,1,1.53-1.61,5,5,0,0,1,3.18-.8C134.12,166.17,134.58,166.46,134.55,166.51Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M145.05,162.52l-8.32-2.88-2.47-.7-5.82-2.76-6.62,2.47s.15,2.26,1.89,1.64l-6.94,2.29s.57,1.65.88,1.76-4.07.47-4.07.47,0,2.23,4.15,2.19,5.76-.75,5.76-.75l3.33.89-.13,2-4.32-.19.45,2.8a45.47,45.47,0,0,0,5.38.76s7,.1,8.9-.82,4.32-2.23,4.32-2.23"
                                                style="fill:none"></path>
                                            <path
                                                d="M141.42,169.44a.82.82,0,0,1-.2.13l-.63.36-2.42,1.31a7.79,7.79,0,0,1-1.83.82,17.49,17.49,0,0,1-2.35.38c-1.7.17-3.64.24-5.79.24h0l-2.61-.27a16.81,16.81,0,0,1-2.86-.49l-.1,0,0-.13c-.14-.87-.29-1.82-.45-2.79l-.05-.28h.28l4.32.18-.26.22c0-.61.09-1.29.13-2l.19.26-3.34-.89h.17a17.57,17.57,0,0,1-5,.76,11.72,11.72,0,0,1-2.63-.13,3.38,3.38,0,0,1-2.37-1.44,2,2,0,0,1-.26-.86v-.23l.25,0c1-.09,2.07-.18,3.08-.29l.74-.1.16,0h0l0,.05a.21.21,0,0,0-.06.22c0,.09.18.21.14.17a.55.55,0,0,1-.16-.1,1.59,1.59,0,0,1-.27-.38,11.6,11.6,0,0,1-.6-1.42l-.09-.25.25-.08,7-2.28.16.46a1.86,1.86,0,0,1-.88.1,1.32,1.32,0,0,1-.78-.45,2.73,2.73,0,0,1-.56-1.51l0-.17.18-.07,6.63-2.44.08,0,.08,0,5.81,2.79h0l2.43.7,2.12.75,3.36,1.22,2.11.78a3.77,3.77,0,0,1,.72.3,7,7,0,0,1-.75-.21l-2.14-.69-3.39-1.13-2.12-.71-2.44-.66h0l-5.84-2.73h.17l-6.62,2.49.16-.24a2.27,2.27,0,0,0,.45,1.23,1,1,0,0,0,1.12.2l.16.47-6.93,2.3.16-.33a8.84,8.84,0,0,0,.57,1.34,1.21,1.21,0,0,0,.16.25h0a.33.33,0,0,0-.06.12h0c.1-.26,0-.07.07-.12l.07,0a.27.27,0,0,1,.09.15.26.26,0,0,1-.07.24c-.08.08-.06.05-.08.06l-.09,0-.21,0-.77.1c-1,.12-2,.21-3.09.3l.23-.25a1.56,1.56,0,0,0,.19.59,2.88,2.88,0,0,0,2,1.19,11.13,11.13,0,0,0,2.52.12,17.25,17.25,0,0,0,4.81-.7l.1,0h.07l3.33.9.2,0,0,.2c0,.69-.09,1.37-.13,2l0,.24h-.24l-4.31-.2.24-.27c.15,1,.3,1.93.43,2.8l-.12-.16a18.62,18.62,0,0,0,2.72.47l2.59.29h0c2.13,0,4.06,0,5.75-.16a16.88,16.88,0,0,0,2.32-.32,8,8,0,0,0,1.8-.76l2.46-1.22.65-.3C141.34,169.46,141.41,169.43,141.42,169.44Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M133.06,161.91a7.7,7.7,0,0,1-2.57,2.61,7.85,7.85,0,0,1-3.31,1.58c-.06-.14,1.4-.85,3-2S132.94,161.81,133.06,161.91Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M181.79,195.46l-19.37-1.63-22.84,8.69-5,3.06L141.7,230s35.79-21.09,37.31-22.89A13,13,0,0,0,181.79,195.46Z"
                                                style="fill:currentColor"></path>
                                            <path
                                                d="M78.39,213.41l-6.66,4.13,15.38,60.55L84.32,313c4,3.46,14,6.43,33,5.35S149,309,149,309l-1.82-35.91-4.33-40.52L138,204.86l-14.64,1.06-5.71-3.38-2.56,1.28-3.28,9.1-8.54-6.18-10-4.81-3.65,6.81Z"
                                                style="fill:currentColor"></path>
                                            <path
                                                d="M138,211.91a8,8,0,0,1,.52,1.34c.32.88.72,2.16,1.2,3.76a123.1,123.1,0,0,1,3,12.66,123.69,123.69,0,0,1,1.58,12.9c.11,1.66.16,3,.17,3.93a6.83,6.83,0,0,1,0,1.45,9.09,9.09,0,0,1-.17-1.44c-.09-1-.2-2.33-.34-3.91-.31-3.3-.84-7.86-1.73-12.84s-1.95-9.44-2.8-12.65c-.41-1.53-.76-2.81-1-3.8A6.62,6.62,0,0,1,138,211.91Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M109.08,212.39a4,4,0,0,1-1.38-.51,8.79,8.79,0,0,1-3-2.59l.36-.1a33.9,33.9,0,0,1-1.79,8.75l-.11.32-.28-.19-.7-.49c-3.45-2.37-6.55-4.54-8.78-6.14l-2.62-1.91a5.28,5.28,0,0,1-.92-.76,5.13,5.13,0,0,1,1,.59l2.71,1.78c2.29,1.51,5.42,3.64,8.86,6l.71.48-.4.13a36.63,36.63,0,0,0,1.88-8.61l0-.54.31.44a9.33,9.33,0,0,0,2.81,2.63C108.61,212.16,109.1,212.34,109.08,212.39Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M122.77,207a31.89,31.89,0,0,1-3.25,3.69l-.18.19-.18-.2a22.41,22.41,0,0,0-2.17-2.21c-.42-.36-.83-.7-1.24-1l-.61-.45A.69.69,0,0,0,115,207s0,0-.09.15l-.93,2.38a10.81,10.81,0,0,1-1,2.15,10.21,10.21,0,0,1,.64-2.28c.26-.75.54-1.56.83-2.42a.71.71,0,0,1,.35-.43.64.64,0,0,1,.58.09l.64.46c.43.31.86.66,1.28,1a18.68,18.68,0,0,1,2.2,2.29l-.36,0A32,32,0,0,1,122.77,207Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M118.81,315.73A41.42,41.42,0,1,1,109,394h0a41.42,41.42,0,0,1,9.85-78.26Zm14.77,78.68a38.61,38.61,0,1,0-23.45-2.93A38.61,38.61,0,0,0,133.58,394.41Z"
                                                style="fill:#455a64"></path>
                                            <path
                                                d="M126.38,399.87a43.62,43.62,0,1,1,14.94-2.66A43.32,43.32,0,0,1,126.38,399.87Zm.09-80.11a36.66,36.66,0,1,0,6.74,72.69h0a36.8,36.8,0,0,0,26.47-20.55,36.68,36.68,0,0,0-33.21-52.14Z"
                                                style="fill:#455a64"></path>
                                            <path
                                                d="M25.67,316l.37-.9c.78-1.93,2.5-3.06,3.84-2.51l60.54,24.63c.3.12.4.57.23,1l-2.58,6.34c-.18.43-.56.68-.86.56L26.67,320.44C25.33,319.89,24.88,317.89,25.67,316Z"
                                                style="fill:#455a64"></path>
                                            <path
                                                d="M82.21,246.24l-7.28,24.09,3.65,49.1-10.74,1.35S55.54,279,56.76,271.44,63,241.86,63,241.86Z"
                                                style="fill:#ffbe9d"></path>
                                            <path
                                                d="M78.55,319.08l5,8.54,3.12,8L82,333.79s-2,9.66-2.81,9.91-3.06-.53-2.83-2.38a3.06,3.06,0,0,1-2.55.84c-1.42-.29-1.76-1.21-1.6-3,0,0-1.65,1.34-2.64.51a3,3,0,0,1-.89-2.3s-2.15.18-2.45-.93a18.52,18.52,0,0,1-.12-5.52c.25-1.22,1.29-6.18,1.29-6.18l.48-4Z"
                                                style="fill:#ffbe9d"></path>
                                            <path
                                                d="M77.38,335.75a9.22,9.22,0,0,0-.75,2.74,9.35,9.35,0,0,0-.31,2.83,9.1,9.1,0,0,0,.75-2.74A9.35,9.35,0,0,0,77.38,335.75Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M73,334.64a5.73,5.73,0,0,0-.67,2.18,6,6,0,0,0-.23,2.28,6.12,6.12,0,0,0,.67-2.19A6.19,6.19,0,0,0,73,334.64Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M69.34,333.61A5.82,5.82,0,0,0,69,335.5c-.17,1-.44,1.85-.31,1.9a3.08,3.08,0,0,0,.75-1.83A3.55,3.55,0,0,0,69.34,333.61Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M82.33,331a10.35,10.35,0,0,0-.8,2.68,11,11,0,0,0-.52,2.75,7.37,7.37,0,0,0,.95-2.64A7.65,7.65,0,0,0,82.33,331Z"
                                                style="fill:#eb996e"></path>
                                            <path
                                                d="M56.17,287.66c0-.82-3.36-12.26-2.34-18.19s13.22-46,14.86-48.86a12.49,12.49,0,0,1,5.21-4.42,19.94,19.94,0,0,1,9.71,12.19c2.45,8.79,2.45,19.82,2.45,19.82l-9.81,24.33,1.17,13.82Z"
                                                style="fill:currentColor"></path>
                                            <path
                                                d="M85.44,247.4c-.1,0,.09-1.8,0-4.68a41.14,41.14,0,0,0-.49-5,40.65,40.65,0,0,0-3.72-11.75,41.55,41.55,0,0,0-2.5-4.39c-1.58-2.42-2.76-3.77-2.69-3.83a5.8,5.8,0,0,1,.88.91A27.4,27.4,0,0,1,79,221.34a37.2,37.2,0,0,1,2.62,4.38,38.62,38.62,0,0,1,3.77,11.9,38.46,38.46,0,0,1,.38,5.1,27.16,27.16,0,0,1-.17,3.43A6.59,6.59,0,0,1,85.44,247.4Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M84.81,252.49a18,18,0,0,1-1,3c-.71,1.85-1.78,4.36-3,7.1l-3.16,7a22.57,22.57,0,0,1-1.36,2.89,18,18,0,0,1,1-3c.71-1.85,1.78-4.36,3-7.1l3.16-7A22.57,22.57,0,0,1,84.81,252.49Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M76.82,273.47a45.71,45.71,0,0,0-6.72-2.92,45.15,45.15,0,0,0-7.22-1.27,6.85,6.85,0,0,1,2.18-.12,21.57,21.57,0,0,1,5.19.89,21.09,21.09,0,0,1,4.82,2.13A6.82,6.82,0,0,1,76.82,273.47Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M140.68,342.38c.09.11-7.79,7-17.61,15.41s-17.85,15.12-17.94,15,7.79-7,17.61-15.4S140.59,342.27,140.68,342.38Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M150.82,342.38c.1.11-6.54,6-14.83,13.09s-15.07,12.81-15.17,12.7,6.55-6,14.83-13.09S150.73,342.27,150.82,342.38Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M165.75,356.43s0-.21-.06-.63-.06-1.06-.12-1.87c0-.41,0-.87-.08-1.37s-.16-1.05-.25-1.65-.19-1.23-.3-1.91-.34-1.38-.51-2.14a37.83,37.83,0,0,0-4.36-10.43,39.14,39.14,0,0,0-9.95-11.1l-1.69-1.26c-.6-.39-1.22-.74-1.84-1.12s-1.23-.8-1.91-1.11l-2-1-1-.49-1.09-.39-2.2-.8c-.75-.25-1.53-.41-2.3-.62a20.4,20.4,0,0,0-2.37-.54,36.24,36.24,0,0,0-4.94-.57c-.84,0-1.69-.11-2.55-.1l-2.58.14c-.44,0-.88,0-1.31.08l-1.3.2c-.87.15-1.76.25-2.63.43a41.21,41.21,0,0,0-5.21,1.53,40.79,40.79,0,0,0-5.09,2.24c-.83.45-1.62,1-2.44,1.45-.4.26-.82.48-1.2.76l-1.15.87A35.59,35.59,0,0,0,95,333.35l-.9,1.2-.79,1.29-.78,1.29a10,10,0,0,0-.73,1.33l-1.32,2.75c-.36,1-.71,1.93-1.06,2.9a38.67,38.67,0,0,0,0,24.64c.36,1,.71,1.93,1.06,2.89s.89,1.84,1.33,2.76l.33.68.4.65.78,1.29.79,1.29.9,1.2A45,45,0,0,0,98.82,384a46,46,0,0,0,4.43,3.77l1.15.86c.39.29.81.5,1.21.76.82.48,1.61,1,2.43,1.45a40.11,40.11,0,0,0,5.1,2.24,41.21,41.21,0,0,0,5.21,1.53c.87.18,1.76.28,2.63.43l1.3.2c.44.06.87.05,1.31.08l2.58.14c.86,0,1.71-.07,2.55-.1a36.24,36.24,0,0,0,4.94-.57,18.53,18.53,0,0,0,2.37-.54c.77-.21,1.56-.37,2.3-.61l2.2-.81,1.09-.39,1-.49,2-1c.68-.31,1.28-.75,1.91-1.11s1.24-.73,1.84-1.12l1.69-1.26a39,39,0,0,0,9.95-11.1A37.83,37.83,0,0,0,164.43,366c.17-.76.43-1.45.51-2.14s.21-1.32.3-1.91.2-1.14.25-1.64.06-1,.08-1.38q.09-1.2.12-1.86c0-.42.06-.64.06-.64s0,.22,0,.64,0,1.06-.07,1.87q0,.62-.06,1.38c0,.5-.14,1.05-.22,1.65l-.28,1.92a22.1,22.1,0,0,1-.5,2.16,37,37,0,0,1-4.3,10.53,39.21,39.21,0,0,1-10,11.24l-1.7,1.28c-.6.39-1.23.76-1.85,1.14s-1.24.81-1.92,1.13l-2.05,1-1,.49-1.1.41-2.22.81c-.75.26-1.54.42-2.33.63a17.28,17.28,0,0,1-2.39.55,35.43,35.43,0,0,1-5,.59c-.86,0-1.71.12-2.58.11l-2.62-.13c-.43,0-.88,0-1.32-.08l-1.32-.2c-.88-.15-1.77-.25-2.66-.43a41,41,0,0,1-5.27-1.54,39.15,39.15,0,0,1-5.17-2.26c-.83-.45-1.63-1-2.46-1.46-.41-.26-.84-.48-1.23-.77L103,388.2a43.51,43.51,0,0,1-4.49-3.81,42.66,42.66,0,0,1-3.88-4.58l-.92-1.21-.79-1.31-.8-1.31-.4-.65-.34-.7L90,371.84l-1.08-2.93a39.22,39.22,0,0,1,0-25L90,341c.45-.93.9-1.86,1.34-2.79a11.8,11.8,0,0,1,.74-1.35l.8-1.31.8-1.3.91-1.21a45.1,45.1,0,0,1,3.88-4.58,43.51,43.51,0,0,1,4.49-3.81l1.17-.87a14,14,0,0,1,1.22-.78c.83-.48,1.63-1,2.46-1.46a40.51,40.51,0,0,1,5.17-2.26,41,41,0,0,1,5.27-1.54c.89-.18,1.78-.28,2.66-.43l1.32-.2c.44-.05.88-.05,1.32-.08l2.62-.13c.86,0,1.72.08,2.57.11a35.4,35.4,0,0,1,5,.59,21.25,21.25,0,0,1,2.39.55c.78.21,1.57.38,2.33.63l2.22.81,1.09.41,1,.5,2,1a21.57,21.57,0,0,1,1.93,1.12c.62.38,1.25.75,1.85,1.14l1.7,1.28a39.21,39.21,0,0,1,10,11.24,37,37,0,0,1,4.3,10.53c.17.76.42,1.47.5,2.16s.19,1.33.28,1.92.18,1.15.22,1.65,0,1,.06,1.38c0,.81,0,1.43.07,1.87S165.75,356.43,165.75,356.43Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M151.24,377.3a13.88,13.88,0,0,1,1-1.34,36.88,36.88,0,0,0,2.5-3.75,34.51,34.51,0,0,0,3-28.62,41,41,0,0,0-1.67-4.19,11,11,0,0,1-.69-1.51s.1.11.25.35.37.59.62,1.07a30.42,30.42,0,0,1,1.83,4.16,33.4,33.4,0,0,1-3,28.93,31.64,31.64,0,0,1-2.66,3.69c-.34.41-.64.71-.83.92S151.26,377.31,151.24,377.3Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M149.17,380.89c.07.13-.24.44-.69.7s-.88.36-.95.24.24-.44.69-.7S149.1,380.77,149.17,380.89Z"
                                                style="fill:#263238"></path>
                                            <path
                                                d="M97.61,373.26a2,2,0,0,1-.24-.47c-.14-.31-.36-.77-.59-1.39a36.35,36.35,0,0,1-1.59-5.34,38.52,38.52,0,0,1,9.26-34.26,34.64,34.64,0,0,1,4.06-3.82c.5-.42.93-.7,1.21-.91s.43-.3.45-.28-.54.49-1.53,1.35a41.16,41.16,0,0,0-3.92,3.9A39.36,39.36,0,0,0,95.56,366,42,42,0,0,0,97,371.33C97.39,372.57,97.65,373.25,97.61,373.26Z"
                                                style="fill:#fff"></path>
                                            <path
                                                d="M120.82,324.25a10.84,10.84,0,0,1-4.67.39,5.36,5.36,0,0,1,2.31-.46A5.48,5.48,0,0,1,120.82,324.25Z"
                                                style="fill:#fff"></path>
                                        </g>
                                    </svg>
                                    <h4 class="text-muted">{{ translate('No Domains Available', 'general') }}</h4>
                                    <p class="text-muted">
                                        {{ translate('It looks like there are no domains to display. Please check back later.', 'general') }}
                                    </p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <div class="table-footer mt-3">
            <div class="row row-cols-auto justify-content-between align-items-center g-3">
                <div class="col">
                    <span>
                        {{ translate('Showing', 'general') }} {{ $domains->firstItem() }}
                        {{ translate('to', 'general') }}
                        {{ $domains->lastItem() }} {{ translate('of', 'general') }}
                        {{ $domains->total() }} {{ translate('entries', 'general') }}
                    </span>
                </div>
                <div class="col">
                    {{ $domains->appends(request()->query())->links() }}
                </div>
            </div>
        </div>
    </div>

    <x-delete-modal />
@endsection
